#include "Menu.h"

// nothing doing in the constructor and destructor
Menu::Menu()
{

}

Menu::~Menu()
{

}

void Menu::init()
{
    // initialises the default values

    _start = false;

    _mainSelection = 1;

    _difficulty = 2;

    _difSelection = _difficulty;

    _level = 1;

    _lvlSelection = _level;

    _buttonPressed = false;

    _menuScreen = "main";

    printf("Menu initialised\n");
}

void Menu::update()
{
    //moves arrow around menus
    moveArrow();

    //checks if a button has been pressed then checks what should be altered depending on the currently selected item
    if (_buttonPressed) {
        selectItem();
    }
}

void Menu::moveArrow()
{
    //each part of the menu has different selection tracker, this means that it will remember what was selected before moving between menu screens

    if (_menuScreen == "main" ) {
        if (_d == N && _mainSelection > 1) {    //checks the menu arrow location and direction wanting to be moved
            _mainSelection -= 1;                //if there is still a postion to be moved to in that direction, the currently selected menu item changes
            //all the menu navigation functions in the same way
        } else if (_d == S && _mainSelection < 3) {
            _mainSelection += 1;
        }
    } else if (_menuScreen == "dif" ) {
        if (_d == N && _difSelection > 1) {
            _difSelection -= 1;
        } else if (_d == S && _difSelection < 4) {
            _difSelection += 1;
        }
    } else if (_menuScreen == "lvl" ) {
        if (_d == N && _lvlSelection > 1) {
            _lvlSelection -= 1;
        } else if (_d == S && _lvlSelection < 3) {
            _lvlSelection += 1;
        }
    }
}

void Menu::selectItem()
{
    if (_menuScreen == "main" ) {           //checks the menu screen
        if (_mainSelection == 1) {          //checks what the current selection is
            _start = true;                  //applies the needed change depending on the selection
            printf("Game Start\n");
        } else if (_mainSelection == 2) {
            _menuScreen = "lvl";
            printf("Menu Screen Changed\n");
        } else if (_mainSelection == 3) {
            _menuScreen = "dif";
            printf("Menu Screen Changed\n");
        }
    } else {                                //an else is used as the other two menu screen MUST return to the main menu once a selection is made
        if (_menuScreen == "dif" ) {
            if (_difSelection == 1) {
                _difficulty = 1;
            } else if (_difSelection == 2) {
                _difficulty = 2;
            } else if (_difSelection == 3) {
                _difficulty = 3;
            } else if (_difSelection == 4) {
                _difficulty = 4;
            }
        } else if (_menuScreen == "lvl" ) {
            if (_lvlSelection == 1) {
                _level = 1;
            } else if (_lvlSelection == 2) {
                _level = 2;
            } else if (_lvlSelection == 3) {
                _level = 3;
            }
        }

        _menuScreen = "main";               //returns to the main menu
        printf("Menu Screen Changed\n");
    }
}

void Menu::read_input(Gamepad &pad)
{
    _buttonPressed = false;


    //checks if any button on the top of the gamepad has been pressed, there is no need to limit the user to one type of button
    if ( pad.check_event(Gamepad::START_PRESSED) || pad.check_event(Gamepad::A_PRESSED) || pad.check_event(Gamepad::B_PRESSED) || pad.check_event(Gamepad::X_PRESSED) || pad.check_event(Gamepad::Y_PRESSED) ||pad.check_event(Gamepad::BACK_PRESSED)) {
        _buttonPressed = true;
        
        printf("Button Pressed\n");
        
        pad.tone(750.0,0.1);    //plays a noise to show the user that the item has been selected
        wait(0.1);          //waits to reduce 'ghosting' of inputs
        
    }
    _d = pad.get_direction();   //gets the current direction of the joystick for later use

}

void Menu::draw(N5110 &lcd)
{
    lcd.drawRect(0,0,84,48,FILL_TRANSPARENT);       //draws an outline
    if (_menuScreen == "main" ) {                   //checks the currently selected screen

        lcd.printString(" Start",2,1);              //draws the related elements
        lcd.printString(" Level Select",2,2);
        lcd.printString(" Difficulty",2,3);

        lcd.printString(">",2,_mainSelection);      //draws the selection arrow

        int _snake[8][40] =   {                     //makes a snake sprite to be drawn
            { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            { 0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            { 0,0,0,0,1,0,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,0},
            { 0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
            { 0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,0,0},
            { 0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
            { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}

        };

        lcd.drawSprite(10,35,8,40,(int *)_snake);   //draws the snake sprite bellow the menu elements for decoration

    } else if ( _menuScreen == "dif") {

        lcd.printString(" Easy",2,1);
        lcd.printString(" Normal",2,2);
        lcd.printString(" Hard",2,3);
        lcd.printString(" Adaptive",2,4);

        lcd.printString(">",2,_difSelection);

    }   else if ( _menuScreen == "lvl") {

        lcd.printString(" 1",2,1);
        lcd.printString(" 2",2,2);
        lcd.printString(" 3",2,3);

        lcd.printString(">",2,_lvlSelection);
    }
}

bool Menu::started()
{
    return _start;
}

int Menu::getDif()
{
    return _difficulty;
}

int Menu::getLvl()
{
    return _level;
}


