#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Snek.h"
#include "Food.h"

/** The Game Engine class
* @brief Handles all failure states and game drawing
* @author Andrew J. Moore
* @date May, 2018
*/

class Engine
{

public:

    /** Constructor */
    Engine();

    /** Destructor */
    ~Engine();

    /** Initialisation function   */
    void init();

    /** Reads and stores the current inputs from the gamepad
    * @param the current state of the gamepad (Gamepad)
    */
    void read_input(Gamepad &pad);

    /** Updates the current game state
    * @param the gamepad's functions as it is needed to use the speaker (Gamepad)
    */
    void update(Gamepad &pad);

    /** Draws the current state of the game
    * @param the LCD so that it can be drawn to (N5110)
    */
    void draw(N5110 &lcd);

    /** Applies a splash screen to signify a game over state has been reached
    * @param the LCD so that it can be drawn to (N5110)
    */
    void gameOverScreen(N5110 &lcd);

    /** Gets the current score
    * @return the current score
    */
    float getScore();

    /** Gets the current game state
    * @return the value of _gameOver
    */
    bool getGameOver();

    /** Sets the current level
    * @param the level to be set to (int)
    */
    void setLvl(int _levelToSet);

private:

    //Private Variables
    int _score;
    Direction _d;
    int _grid[22][22];
    Snek _solid; //Named after Metal Gear Solid character Solid Snake to reduce confusion when debugging
    Food _noodles; //Common foodstuffs in MGS, once again to reduce confusion
    bool _gameOver;
    int _lvl;

    //Private Methods
    string convertString(int a);
    void loadLvl();
    void lvlOne();
    void lvlTwo();
    void lvlThree();
    bool checkFood();
    void growSnake();
    void checkGameOverAndSetGrid();

    //Testing Methods
    void gameTest();
    bool snakeTest();
    bool foodTest();
};