#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** The Menu class
* @brief Handles all logic and drawing related to the menu, doesn't set any selected options in the game engine directly
* @author Andrew J. Moore
* @date May, 2018
*/

class Menu
{
public:

    /** Constructor */
    Menu();

    /** Destructor */
    ~Menu();

    /** Initialisation function   */
    void init();

    /** Reads and stores the current inputs from the gamepad
    * @param the current state of the gamepad (Gamepad)
    */
    void read_input(Gamepad &pad);

    /** Updates the current menu state    */
    void update();

    /** Draws the current state of the menu
    * @param the LCD so that it can be drawn to (N5110)
    */
    void draw(N5110 &lcd);

    /** Gets if 'Start' has been selected in the menu
    * @return the value of _start
    */
    bool started();

    /** Gets the current difficulty setting
    * @return the value of _difficulty
    */
    int getDif();

    /** Gets the currently selected level
    * @return the value of _level
    */
    int getLvl();


private:

    //Private Variables
    char _d;
    bool _start;
    int _mainSelection;
    int _difSelection;
    int _lvlSelection;
    bool _buttonPressed;
    string _menuScreen;
    int _difficulty;
    int _level;

    //Private Methods
    void moveArrow();
    void selectItem();

};