#include "gameEngine.h"

N5110 lcd(PTC9, PTC0, PTC7, PTD2, PTD1, PTC11);
Gamepad pad;

sprites Sprites;
playersprite Player;



void gameEngine::init()
{

    // initialise the lcd and gamepad
    lcd.init();
    lcd.setContrast(0.3);
    pad.init ();
    //set initial number of lives to 1
    lives = 1;
    //set initial location conditions for the player and car(s) and score
    x_player = 24;
    y_player = 29;

    x_car = 4;
    y_car = 0;
    x_car2 = 24;
    y_car2 = -40;

    //(re)set score to 0
    score = 0;
    srand(time(NULL));
}

void gameEngine::startUp()
{
    //print start screen
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        lcd.drawSprite (1,1,20,70,(int*) titlescreen);
        lcd.printString ("PRESS START", 3,5);
        lcd.printString ("SPEED", 3,3);
        pot_value = pad.read_pot();
        sprintf (speed, "%.1f", (pot_value*10)); //convert an integer to pointer
        lcd.printString(speed,55,3);

        lcd.refresh();
        wait(0.2);
    }
}

void gameEngine::newGame()
{
    printf("newgamereached\n"); //checking if new game function reached

    lcd.clear(); //clear the lcd

    //print the player sprite:
    lcd.drawSprite(x_player,y_player,20,15,(int*) player); 

    //print road lines:
    lcd.drawLine(1,1,1,1500,2);

    lcd.drawLine(21,1,21,1500,2);

    lcd.drawLine(41,1,41,1500,2);

    lcd.drawLine(61,1,61,1500,2);

    // allow user control of player sprite with gamepad:
    Player.move();

    //cars move down the road:
    Sprites.move();

    // re-generate cars continously:
    Sprites.respawn();

    // make it so that after the player reaches a certain score, occasionally
    //(when both oncoming cars in the same lane) one car changes lane
    //this makes it harder for the player:

    Sprites.difficultyIncrease();


    //if there is a collision, display "game over" screen:


    if (x_car == x_player && y_car > 12 && y_car < 50) {
        printf("collision1\n");// to tell with which sprite the collision was
        y_car = y_car;
        y_car2 = y_car2;
        score=score;
        lives--;
        printf("lives=%d\n", lives);

    }
    if (x_car2 == x_player && y_car2 > 12 && y_car2 < 50) {
        printf("collision2\n");
        y_car2 = y_car2;
        y_car = y_car;
        score=score;
        lives--;
        printf("lives=%d\n", lives);

    }

    Player.move();

    score++;//increase score

    sprintf (str, "%d", (score/10)); //convert an integer to pointer.
    lcd.printString(str,64,1); //display score

    //constantly update score on the screen:
    pot_value = pad.read_pot();
    printf("pot_value = %f\n", pot_value);
    float wait_time = pot_value/10;

    lcd.refresh();

    wait(0.1-wait_time);


}


//Displays gameOver screen
void gameEngine::gameOver()
{
    printf("reached gameover\n");
    if (lives ==0) {


        while ( pad.check_event(Gamepad::START_PRESSED) == false) {

            printf("gameoverlives=%d\n", lives);
            lcd.clear();
            //flash LEDs:
            pad.leds_on();
            wait(0.2);
            pad.leds_off();
            lcd.printString(str,64,1);
            lcd.printString ("GAME OVER", 3,1);
            lcd.printString ("PRESS START", 3,3);
            lcd.refresh();
            wait(0.2);
        }
        init ();
    }
}
