/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Wei Wei
Username: el15ww
Student ID Number: 200975452
Date:
*/
///////////pre-processor directives////////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "snake_engine.h"
#include  "snake.h"
/////////////objects///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);

Gamepad pad;
snake_engine engine;
////////////prototypes//////////////
void init();
void render();
void welcome();
void reset();



/////////structure/////////
struct UserInput {
    Direction d;
    float mag;
};
////////////functions//////////
int main()
{
    init();
    welcome();
    while (1) {
                if ((engine.clision  == 1)) { //wall collision check. if collision happens == 1. gameover. initialise
            init();
            welcome();//back to welcompage
            render();  //first draw initial frame
            wait(0.03f);//frame period
            engine.clision = 0;// no collision when it backs to welcomepage
        }

        engine.read_input(pad);//engine recive command from gamepad
        engine.update(pad, lcd);//update all the functions
        render();//draw the frame
        wait(0.05f);
        reset();//initialise the reset page.
    }

}
void init()//initialise the gamepad , lcd and engine
{
    lcd.init();
    pad.init();
    engine.init();
}

void render()
{    //clear screen , redraw the frame and game
    lcd.clear();
    engine.draw(lcd);
    lcd.refresh();
}
void welcome()
{//welcome page.
    lcd.printString("     Simple    ",0,1);
    lcd.printString("Snake Game",0,2);
    lcd.printString("   WEI WEI  ",0,3);
    lcd.printString("200975452",0,4);
    lcd.printString("  PRESS START ",0,5);
    lcd.refresh();
    lcd.clear();
    wait(0.5);
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {//wait until the start button pressed
    }

}

void reset()
{//game reset.
    if ( pad.check_event(Gamepad::BACK_PRESSED) == true) {//if the back button pressed. returns to welcomepage.
        lcd.clear();
        lcd.refresh();//lcd clear screen and refresh

        init();
        welcome();
    }
}


    


