/*
@author abdul rahman alhinai 200904758
@brief main folder of the game (gravity) 
@date may 2017
*/
///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "FXOS8700CQ.h"
#include "N5110.h"
#include "PongEngine.h"

#define PADDLE_RADIUS 4
#define BALL_SIZE 3
#define BALL_SPEED 2
#define BALL_LVL 0

/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
FXOS8700CQ device(I2C_SDA,I2C_SCL);
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
PongEngine pong;
///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
///////////// functions ////////////////
int main()
{
    int fps = 8;  // frames per second
 device.init();
    init();
    welcome();
    Data values = device.get_values();


    render();  // draw initial frame
    wait(1.0f/fps);

    // game loop - read input, update the game state and render the display
    while (1) {
        pong.read_input(pad,device);
        pong.update(BALL_SPEED,pad,lcd,device);
        render();
        wait(1.0f/fps);
    }
}

void init()
{
    // need to initialise LCD and Gamepad
    lcd.init();
    pad.init();
 device.init();
    // initialise the game
    pong.init(PADDLE_RADIUS,BALL_SIZE,BALL_SPEED,device);

}

void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    pong.draw(lcd);
    lcd.refresh();
}

void welcome()
{

    lcd.printString("    gravity    ",0,1);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();

    // wait flashing LEDs until start button is pressed
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }

}