/*
@author abdul rahman alhinai 200904758
@brief the game angine where the collectian of the classes work 
@date5/5/2017
*/
#include "PongEngine.h"

PongEngine::PongEngine()
{

}

PongEngine::~PongEngine()
{

}

void PongEngine::init(int paddle_radius,int ball_size,int speed, FXOS8700CQ &device )
{
    // initialise the game parameters
    _paddle_radius = paddle_radius;
    _ball_size = ball_size;
    _speed = speed;
   

    // puts paddles and ball in middle
    _p1.init(_paddle_radius);
    
    _ball.init(_ball_size,_speed,device);
}

void PongEngine::read_input(Gamepad &pad,FXOS8700CQ &device)
{
    Data values = device.get_values();  //to find data for the roll and pitch angels
    
}

void PongEngine::draw(N5110 &lcd)
{
    // draw the elements in the LCD buffer
    // pitch
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);
    
    //score
    print_scores(lcd);
    // paddles/basket
    _p1.draw(lcd);
    // ball
    _ball.draw(lcd);
}

void PongEngine::update(int speed,Gamepad &pad,N5110 &lcd,FXOS8700CQ &device)
{
 
    _ball.update( _speed, device);
    Data values = device.get_values();  //to find data for the roll and pitch angels
       
    check_wall_collision(pad, lcd,device); ///lose the game if it has
    
    check_paddle_collisions(pad,lcd,device);// get a score if it has
}

void PongEngine::check_wall_collision(Gamepad &pad,N5110 &lcd,FXOS8700CQ &device)
{
    // read current ball attributes
    Vector2D ball_pos = _ball.get_pos();
    Vector2D ball_velocity = _ball.get_velocity();
   
    // check p1 positian
    Vector2D p1_pos = _p1.get_pos();
   
    
    Data values = device.get_values();  //to find data for the roll and pitch angels

    // check if hit top wall
    if (ball_pos.y <= 1) {  //  1 due to 1 pixel boundary
         lcd.printString("   gameover   ",0,1);//game over string
         lcd.refresh();
        // audio feedback
        pad.tone(100.0,0.1);
        //reset the score,lvl and ball pos
        _p1.reset_score();
        _ball.reset_pos();
        _ball.reset_lvl();
        //print to test (debug)
    printf( "top wall \n");
        wait(1);
        
    }
    // check if hit bottom wall
    else if (ball_pos.y  >= (HEIGHT-1) ) { // bottom pixel is 47
         lcd.printString("    gameover   ",0,1);//game over string
         lcd.refresh();
        // audio feedback
        pad.tone(100.0,0.1);
        //reset the score,lvl and ball pos
        _p1.reset_score();
        _ball.reset_pos();
        _ball.reset_lvl();
        printf( "bottom wall \n");//debug
        
         wait(1);
        }
        else if (ball_pos.x  <= 1) {
         // if hit right wall
         lcd.printString("     gameover    ",0,1);//game over string
         lcd.refresh();
        // audio feedback
        pad.tone(100.0,0.1);
        //reset the score,lvl and ball pos
        _p1.reset_score();
        _ball.reset_pos();
        _ball.reset_lvl();
        printf( "right wall \n");//debug
         wait(1);
        }
        else if (ball_pos.x  >= WIDTH-1) {
             // if hit left wall
         lcd.printString("   gameover   ",0,1);//game over string
         lcd.refresh();
        // audio feedback
        pad.tone(100.0,0.1);
        //reset the score,lvl and ball pos
        _p1.reset_score();
        _ball.reset_pos();
        _ball.reset_lvl();
        printf( "left wall \n");//debug
         wait(1);
   
    }

    // update ball parameters
    
    _ball.set_velocity(ball_velocity);
    
    device.get_values();  //to find data for the roll and pitch angels
}

void PongEngine::check_paddle_collisions(Gamepad &pad,N5110 &lcd,FXOS8700CQ &device)
{
    // read current ball attributes
    Vector2D ball_pos = _ball.get_pos();
    Vector2D ball_velocity = _ball.get_velocity();
         
    // check p1 positian
    Vector2D p1_pos = _p1.get_pos();
    
    //get data for roll and pitch angel
    Data values = device.get_values();

    // see if ball has hit the paddle/basket by pos
    if (
        (ball_pos.y ==  p1_pos.y)&&  (ball_pos.x ==  p1_pos.x)
    ) {
        // if it has, add score and lvl
        _p1.add_score();
        _ball.add_lvl();
        // reset ball pos in the middel
        _ball.reset_pos();
        wait(0.5);
         // print  to test (debug)
        printf( "lvl = %2d \n",_lvl); 
        printf( "pitch angle = %f\n",values.pitch);
        printf( "roll angle = %f\n",values.roll);
        // audio feedback
        pad.tone(1000.0,0.1);
    }
    }


void PongEngine::print_scores(N5110 &lcd)
{
    // get scores from paddles
    int p1_score = _p1.get_score();
   int ball_lvl = _ball.get_lvl();
    //print to test
    //printf( "lvl = %2d \n",_lvl); 

    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"%2d",p1_score);
    lcd.printString(buffer1,2,2);  
  
}