/*
@author abdul rahman alhinai 200904758
@brief the game ball class where the ball speed and movement made
@date may 2017
*/
#include "Ball.h"

Ball::Ball()
{

}

Ball::~Ball()
{

}

void Ball::init(int size,int speed, FXOS8700CQ &device)
{
    _size = size;
     speed =2;
    _x = WIDTH/2  ;
    _y = HEIGHT/2 ;
    
     _lvl = 0;    // to increas the speed of the ball
 Data values = device.get_values();


    
     // print each struct member over serial to test and debug
        printf("ax = %f ay = %f az = %f | mx = %f my = %f mz = %f\n"
               ,values.ax, values.ay, values.az
               ,values.mx, values.my, values.mz);
        printf( "pitch angle = %f\n",values.pitch);
        printf( "roll angle = %f\n",values.roll);

    // 9 possibilities. Get angel values for pitch and rolll and set velocities accordingly
    if ((values.pitch >= 30) &&//bottom right
       (values.roll >= 30)) { 
        _velocity.x = speed+_lvl  ;
        _velocity.y = -speed-_lvl;
    } else if ((values.pitch >= 30) && //top right
       (values.roll <= -30)) {
        _velocity.x = speed+_lvl;
        _velocity.y = speed+_lvl;
    } else if ((values.pitch >= 30))  {//right
        _velocity.x = speed+_lvl;
        _velocity.y = 0;
    } else if ((values.pitch <= -30) && //bottom left
       (values.roll >= 30)) {
        _velocity.x = -speed-_lvl;
        _velocity.y = -speed-_lvl;
    }
    else if( (values.pitch <= -30) && //top left 
       (values.roll <= -30)) {
        _velocity.x = -speed-_lvl;
        _velocity.y = speed+_lvl;
    }else if (values.pitch <= -30) { //left
        _velocity.x = -speed-_lvl;
        _velocity.y = 0;
    }
    else if (values.roll >= 30) { //bottom
        _velocity.x = 0;
        _velocity.y = -speed-_lvl;
    }
    else if (values.roll <= -30) { //top
        _velocity.x = 0;
        _velocity.y = speed+_lvl;
    }
    else {                       //stop
        _velocity.x = 0;
        _velocity.y = 0;
    }
}

void Ball::draw(N5110 &lcd)
{
    lcd.drawCircle(_x,_y,_size,FILL_BLACK);
    
}

void Ball::update(int speed, FXOS8700CQ &device)
{
      
      Data values = device.get_values();
      if ((values.pitch >= 30) &&
       (values.roll >= 30)) {
        _velocity.x = -speed -_lvl ;
        _velocity.y = speed+_lvl;
    } else if ((values.pitch >= 30) &&
       (values.roll <= -30)) {
        _velocity.x = -speed-_lvl;
        _velocity.y = -speed-_lvl;
    } else if ((values.pitch >= 30))  {
        _velocity.x = -speed-_lvl;
        _velocity.y = 0;
    } else if ((values.pitch <= -30) &&
       (values.roll >= 30)) {
        _velocity.x = speed+_lvl;
        _velocity.y = speed+_lvl;
    }
    else if( (values.pitch <= -30) &&
       (values.roll <= -30)) {
        _velocity.x = speed+_lvl;
        _velocity.y = -speed-_lvl;
    }else if (values.pitch <= -30) {
        _velocity.x = speed+_lvl;
        _velocity.y = 0;
    }
    else if (values.roll >= 30) {
        _velocity.x = 0;
        _velocity.y = speed+_lvl;
    }
    else if (values.roll <= -30) {
        _velocity.x = 0;
        _velocity.y = -speed-_lvl;
    }
    else {
        _velocity.x = 0;
        _velocity.y = 0;
    }
     
    _x += _velocity.x;
    _y += _velocity.y;
}

void Ball::add_lvl()
{
    _lvl++;
}
int Ball::get_lvl()
{
    return _lvl;
}
void Ball::reset_lvl()
{
    _lvl=0;
}


void Ball::set_velocity(Vector2D v)
{
    _velocity.x = v.x;
    _velocity.y = v.y;
}

Vector2D Ball::get_velocity()
{
    Vector2D v = {_velocity.x,_velocity.y};
    return v;
}

Vector2D Ball::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}


void Ball::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}
void Ball::reset_pos()
{
    _x = WIDTH/2  ;
    _y = HEIGHT/2 ;
}