#ifndef PONGENGINE_H
#define PONGENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "FXOS8700CQ.h"
#include "Gamepad.h"
#include "Ball.h"
#include "Paddle.h"

// gap from edge of screen
#define GAP 2

class PongEngine
{

public:
    PongEngine();
    ~PongEngine();

    void init(int paddle_radius,int ball_size,int speed,FXOS8700CQ &device);
    void read_input(Gamepad &pad,FXOS8700CQ &device);
    void update(int speed, Gamepad &pad,N5110 &lcd, FXOS8700CQ &device);
    void draw(N5110 &lcd);
    
private:

    void check_wall_collision(Gamepad &pad,N5110 &lcd ,FXOS8700CQ &device);
    void check_paddle_collisions(Gamepad &pad,N5110 &lcd,FXOS8700CQ &device);// paddle is the goal
    void print_scores(N5110 &lcd);
    
    Paddle _p1;
    
     
    int _paddle_radius;
    int _ball_size;
    int _speed;
    int _lvl;
    
    // x positions of the paddles
    int _p1x;
    
    
    Ball _ball;
    

};

#endif