#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "FXOS8700CQ.h"
#include "Gamepad.h"
#include "Paddle.h"

class Ball
{

public:
    Ball();
    ~Ball();
    void init(int size,int speed,FXOS8700CQ &device );
    void draw(N5110 &lcd);
    void update(int speed,FXOS8700CQ &device);
    /// accessors and mutators
    void set_velocity(Vector2D v);
    Vector2D get_velocity();
    Vector2D get_pos();
    void set_pos(Vector2D p);
    void reset_pos();
    void reset_lvl();
    void add_lvl();
    int get_lvl();
     
private:

    Vector2D _velocity;
    int _size;
    int _x;
    int _y;
    int _lvl;
};
#endif