#include "Shape.h"

Shape::Shape()
{
}

//Create first shape block
void Shape::Init()
{
    New=0;                //initial the Flag
    ShapePicker();        //Generate a shape from the list
}

/** Rotate 
*
* Rotate the shape by 90 degree clockwise. 
* Insert the shape array into array only for rotating
* Rotate the shape within rotating array and transfer back to shape array  
*/
void Shape::Rotate(Gamepad &pad)
{
    for(int i=1; i<84; i++) {
        for(int j=1; j<48; j++) {
            ArrayRotate[i-1][j-1]=ShapeInit[i][j];  //Transfer the Shape from original array into a new array from rotation  
        }
    }
    int Temp;  //temporarily variable
    for (int i=0; i<2; i++) {
        for (int j=i; j<3-i; j++) {
            Temp=ArrayRotate[i][j];                    //top to temporarily variable
            ArrayRotate[i][j]=ArrayRotate[j][3-i];     //bottom to top
            ArrayRotate[j][3-i]=ArrayRotate[3-i][3-j]; //right to left
            ArrayRotate[3-i][3-j]=ArrayRotate[3-j][i]; //top to bottom
            ArrayRotate[3-j][i]=Temp;                  //temporarily variable to top
        }
    }//reference http://stackoverflow.com/questions/42519/how-do-you-rotate-a-two-dimensional-array
    for(int i=1; i<5; i++) {
        for(int j=1; j<5; j++) {
            printf("%d\n",ArrayRotate[i][j]);          //print the array 
        }
    }//reference http://stackoverflow.com/questions/8442729/is-there-a-way-to-have-printf-properly-print-out-an-array-of-floats-say
 //   printf("x=%d\n",x);                                //print value of x for debug
//  printf("y=%d\n",y);                                //print value of y for debug
    if(pad.check_event(Gamepad::A_PRESSED) == true) {  //event check 
        for(int i=0; i<84; i++) { 
            for(int j=0; j<48; j++) {
                ShapeInit[i][j]=0;                     //clear the array
                ShapeArray[i][j]=0;
            }
        } 
  //      printf("x1=%d\n",x);                           //print value of x for debug
  //      printf("y1=%d\n",y);                           //print value of y for debug
        for(int i=0; i<83; i++) {
            for(int j=0; j<47; j++) {
                ShapeInit[i+1][j+1]=ArrayRotate[i][j]; //transfer the rotated array back to orignail array 
            }
        }
   //     printf("x2=%d\n",x);                           //print value of x for debug 
   //     printf("y2=%d\n",y);                           //print value of y for debug
    }
}

//update the shape array into moving array
void Shape::Update(Gamepad &pad)
{
    int n=14;
    ShapeArray[x+n][y]=0;
    ShapeArray[x+1+n][y]=0;
    ShapeArray[x+2+n][y]=0;
    ShapeArray[x+3+n][y]=0;
    ShapeArray[x+4+n][y]=0;
    ShapeArray[x+5+n][y]=0;

    ShapeArray[x+n][y+1]=0;
    ShapeArray[x+5+n][y+1]=0;

    ShapeArray[x+n][y+2]=0;
    ShapeArray[x+5+n][y+2]=0;

    ShapeArray[x+n][y+3]=0;
    ShapeArray[x+5+n][y+3]=0;

    ShapeArray[x+n][y+4]=0;
    ShapeArray[x+5+n][y+4]=0;

    ShapeArray[x+1+n][y+1]=ShapeInit[l+1][k+1];
    ShapeArray[x+2+n][y+1]=ShapeInit[l+2][k+1];
    ShapeArray[x+3+n][y+1]=ShapeInit[l+3][k+1];
    ShapeArray[x+4+n][y+1]=ShapeInit[l+4][k+1];

    ShapeArray[x+1+n][y+2]=ShapeInit[l+1][k+2];
    ShapeArray[x+2+n][y+2]=ShapeInit[l+2][k+2];
    ShapeArray[x+3+n][y+2]=ShapeInit[l+3][k+2];
    ShapeArray[x+4+n][y+2]=ShapeInit[l+4][k+2];

    ShapeArray[x+1+n][y+3]=ShapeInit[l+1][k+3];
    ShapeArray[x+2+n][y+3]=ShapeInit[l+2][k+3];
    ShapeArray[x+3+n][y+3]=ShapeInit[l+3][k+3];
    ShapeArray[x+4+n][y+3]=ShapeInit[l+4][k+3];

    ShapeArray[x+1+n][y+4]=ShapeInit[l+1][k+4];
    ShapeArray[x+2+n][y+4]=ShapeInit[l+2][k+4];
    ShapeArray[x+3+n][y+4]=ShapeInit[l+3][k+4];
    ShapeArray[x+4+n][y+4]=ShapeInit[l+4][k+4];

}

/** ShapePicker 
*
* Generate a random number from 0-6 and map one number to one shape.
* Use if elseif function to identify which number is generated and present the shape to screen.
* The Function only run when flag is activated.  
*/
void Shape::ShapePicker()
{
    t=time(NULL);
    srand(t);     //create a seed 

    if(New==0) {
        New=1;   //clear flag
        RandomNumber=rand()%7;  //generated a randdom number 
    }

    if(RandomNumber==0) {       //identify the shape 
        T_Shape();              // T shape
        RandomNumber=10;
    } else if(RandomNumber==1) {
        J_Shape();              // J shape
        RandomNumber=10;
    } else if(RandomNumber==2) {
        L_Shape();              // L shape
        RandomNumber=10;
    } else if(RandomNumber==3) {
        O_Shape();              // o shape
        RandomNumber=10;
    } else if(RandomNumber==4) {
        I_Shape();              // I shape
        RandomNumber=10;
    } else if(RandomNumber==5) {
        S_Shape();              // S shape
        RandomNumber=10;
    } else if(RandomNumber==6) {
        Z_Shape();              // Z shape
        RandomNumber=10;
    }
}

//Draw the L shape into the array 
void Shape::L_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=1;
    ShapeInit[l+3][k+1]=0;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=0;
    ShapeInit[l+2][k+2]=1;
    ShapeInit[l+3][k+2]=0;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=0;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=1;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=0;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}

//Draw the O shape into the array 
void Shape::O_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=0;
    ShapeInit[l+3][k+1]=0;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=0;
    ShapeInit[l+2][k+2]=1;
    ShapeInit[l+3][k+2]=1;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=0;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=1;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=0;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}

//Draw the S shape into the array 
void Shape::S_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=0;
    ShapeInit[l+3][k+1]=0;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=0;
    ShapeInit[l+2][k+2]=1;
    ShapeInit[l+3][k+2]=1;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=1;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=0;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=0;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}

//Draw the Z shape into the array 
void Shape::Z_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=0;
    ShapeInit[l+3][k+1]=0;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=1;
    ShapeInit[l+2][k+2]=1;
    ShapeInit[l+3][k+2]=0;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=0;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=1;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=0;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}

//Draw the I shape into the array 
void Shape::I_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=1;
    ShapeInit[l+3][k+1]=0;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=0;
    ShapeInit[l+2][k+2]=1;
    ShapeInit[l+3][k+2]=0;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=0;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=0;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=1;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}
//Draw the J shape into the array 
void Shape::J_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=0;
    ShapeInit[l+3][k+1]=1;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=0;
    ShapeInit[l+2][k+2]=0;
    ShapeInit[l+3][k+2]=1;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=0;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=1;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=0;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}
//Draw the T shape into the array 
void Shape::T_Shape()
{
    ShapeInit[l+1][k+1]=0;
    ShapeInit[l+2][k+1]=0;
    ShapeInit[l+3][k+1]=0;
    ShapeInit[l+4][k+1]=0;

    ShapeInit[l+1][k+2]=1;
    ShapeInit[l+2][k+2]=1;
    ShapeInit[l+3][k+2]=1;
    ShapeInit[l+4][k+2]=0;

    ShapeInit[l+1][k+3]=0;
    ShapeInit[l+2][k+3]=1;
    ShapeInit[l+3][k+3]=0;
    ShapeInit[l+4][k+3]=0;

    ShapeInit[l+1][k+4]=0;
    ShapeInit[l+2][k+4]=0;
    ShapeInit[l+3][k+4]=0;
    ShapeInit[l+4][k+4]=0;
}