#include "mbed.h"
#include "N5110.h"
#include "Engine.h"
#include "Gamepad.h"

/**
*Tetris
*Author Guanxiong Su
*Date May 2017
*/

struct UserInput {
    Direction d;
};

//////////////////Object////////////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Engine Engine;
///////////////Function////////////////////
void Init();
void WelcometoStart();

///////////////MainLoop/////////////////////
int main()
{
    Init();
    WelcometoStart();

    int fps = 4;       //4 frames per second
    wait(1.0f/fps);

    // game loop - read input, update the game state and screen display
    while (1) {
        Engine.ReadInput(pad);
        Engine.Update(lcd,pad);
        Engine.Pixel(lcd);
        wait(1.0f/fps);
    }
}

void Init()
{
    // initialise the LCD and Gamepad
    lcd.init();
    pad.init();
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(0.5); // put LED backlight on 50%

    // initialise the game
    Engine.Init(lcd);
}

void WelcometoStart()
{
    lcd.printString("    Welcome   ",0,2);
    lcd.printString("    Tetris    ",0,3);
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();

    // flashing LEDs until start button is pressed
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        for(int a=0; a<7; a++) {
            pad.led(a,1);                //led on from left to right
            wait(0.1);                   //time delay
        }
        for(int a=6; a>0; a--) {
            pad.led(a,0);                //led off from right to left
            wait(0.1);                   //time delay
        }
    }
}