#ifndef Engine_H
#define Engine_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Shape.h"

/**
@Class of Engine for Tetris
@Author Guanxiong Su
@Date May 2017
*/
class Engine
{

public:
    Engine();
    void Init(N5110 &lcd);
    void ReadInput(Gamepad &pad);
    void Update(N5110 &lcd,Gamepad &pad);
    void Pixel(N5110 &lcd);
    int FillArray[84][48];

private:
    void Boundary();
    void CollisionCheck();
    void Dropping(Gamepad &pad);
    void Movement(Gamepad &pad);
    void SaveBlock();
    void NewBlock();
    void GameOver(N5110 &lcd,Gamepad &pad);
    void DeleteLine();
    void Scores(N5110 &lcd);

    int Score;
    int AddScore;
    int CurrentScore;
    int ScoreDisplay;
    int BottomCollision;
    int LeftSideCollision;
    int RightSideCollision;
    int NEW;
    int Pixels;

    Direction d;
    Shape _Shape;
};
#endif
