#ifndef Obstacles_H
#define Obstacles_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** Class Obstacles
@brief Class responsible for all the functionality of the obstacles including intialization, drawing, moving and updating it
@author Samrudh Sharma
@date
@classes
*/



class Obstacles
{
public:

/** Initialise display
*
*   Powers up the display and turns on backlight (50% brightness default).
*   Intialises the charchter status, x and y co-ordinate of the obstacle.
*/
    void init();
  
 /** Function to draw  the obstacle
*
*   Draws the  obstacle to the display using the N5110 library and its object lcd.  
*   
*/ 
    void draw(N5110 &lcd);
    
/** Updates/Moves Obstacle
*
*   Helps the Obstacle move by updating its position on the screen by 1 pixel each time 
*   therefore setting its speed aswell.
*/  
    void updateObstacle();
    
/** Obstacle Status
*
*   This fuction helps to check whether the obstacle has reached the bottom of the screen and updates the obstacle status
*   to false so that the obstacles can be generated again this creating a continuous flow of obstacles
*   
*   @param p - stores the 2D location i.e. the (x,y) co-ordinate of the cetre point of the obstacle on the screen .
*/ 
    void obstacleStatus(Vector2D p);
    
/** Obstacle Position
*
*   Returns the  2D location i.e. the (x,y) co-ordinate of the cetre point of the obstacle on the screen .
*/  
    Vector2D getObstaclePos();
    
/** Return Obstacle Status
*
*   Returns the  status of the obstacle which is sent to the main, where it is used to determine whether the obstacles have to be intialized or
*   or renderd again.
*/
    bool getObstacleStatus();

private:

//Variables
 int obsPosX; // X cocordinate of the obstacle
 int obsPosY; // Y cocordinate of the obstacle
 bool obStatus; //Variable to store the Obstacles status
   

};
#endif