#ifndef SNAKE_H
#define SNAKE_H


#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Food.h"

/************************Structs************************/
struct snakePart{
    char _x[4000];
    char _y[4000];
    char _dir[4000];
    
    };
    
/************************Class Def************************/

class Snake{
    
/************************Public Vars************************/
    public:
    
        Snake();
        ~Snake();
        void init(int x, int y, int lenght,int _live);
        void draw(N5110 &lcd);
        void update(Gamepad &pad);
        void deadSnake(N5110 &lcd);
        void addPoint();
        void checkWallCollision(N5110 &lcd);
        void checkTailCollision(N5110 &lcd);
        void drawScore(N5110 &lcd);
        int _length;
        int live;
        float waitTime;
        float waitCount;
       
        
        
      
/************************Private Vars************************/        
    private:
        
        
        int _speed;
        int _direction;
        int startx;
        int starty;
        int startl;
        int x;
        Direction d;
        Food _food;
        
        
};
    
    #endif