#include "Snake.h"


#define WIDTH 84
#define HEIGHT 48
#define CEILING 8
#define FLOOR 48

snakePart snek;



Snake::Snake()
{

}
Snake::~Snake()
{
  
}

/************************Functions************************/

void Snake::init(int x, int y, int lenght, int _live){//initalizing the starting variables     
       
    startx=x;//saving these variables for later init
    starty=y;
    startl=lenght;
    live=_live;
    _length = lenght;    
    _food.init();//init food
    for (int i=0;_length>i;i++)//create start snake
    {   
        snek._x[i]=x+i;
        snek._y[i]=y;
        snek._dir[i]=1;
    }
    snek._x[_length]=x+_length;
    snek._x[_length+1]=x+_length+1;
    snek._y[_length]=y;
    snek._dir[_length]=1;
    printf("xog is %d  ", snek._x[_length-1]);
    //printf("initalized");
}//end of init

void Snake::draw(N5110 &lcd){
        checkWallCollision(lcd);// if head==wall game over
        checkTailCollision(lcd);
            if (live!=0){
                lcd.clear();
                waitCount=((float)_length/3)+5;//set wait so the game is speeding up
                waitTime=(1/waitCount);
                wait(waitTime);                
                _food.draw(lcd);//make first food
                lcd.drawRect(0,8,84,48-8,FILL_TRANSPARENT);//draw arena
                drawScore(lcd);
                for ( int i=0; _length>i;i++){//draw snake
                    if (snek._x!=0)
                        {
                            if (snek._y!=0)
                                {
                                    lcd.setPixel(snek._x[i],snek._y[i]);
                                }
                        }
                
                lcd.refresh();
                
                //printf("drawn");
                }
       }//live loop 
       
}//end of draw
void Snake::update(Gamepad &pad){
     
     if (live!=0){
    
            d=pad.get_direction();
            printf("x+1 is %d", snek._x[_length+1]);
            printf("y+1 is %d", snek._y[_length+1]);
            printf("dir+1 is %d", snek._dir[_length+1]);
            printf("length is %d", _length);
    
             /*if ( pad.check_event(Gamepad::A_PRESSED) == true)//testing the addPoint manually
            {
                snek._x[_length+1]=snek._x[_length];//-1
                snek._y[_length+1]=snek._y[_length];
                snek._dir[_length+1]=snek._dir[_length-1];
                _length=_length+1;
                printf("length+1 is %d", _length);
                
            }
            */
            //printf("x is %d  ", snek._x[_length-1]);
            if (snek._dir[_length-1]==1)//set direction according _dir
                {
                    snek._x[_length]++;                    
                }
            
            if (snek._dir[_length-1]==2)
                {
                    snek._y[_length]--;
                
                }
            
            if (snek._dir[_length-1]==3)
                {
                    snek._x[_length]--;                    
                }
                
            if (snek._dir[_length-1]==4)
                {
                    snek._y[_length]++;                                        
                }
            
            for (int i=0 ;_length<i ;i++)
                {                      
                    snek._x[i]=snek._x[i+1];
                    snek._y[i]=snek._y[i+1];
                    //printf("done");                    
                }
            //check dpad which way it is pointing
            //set direction accordingly, 1 is right, up is 2, 3 is left and 4 is down        
            if (d==N){// if stick points up, go up
                
                        if (snek._dir[_length-1]!=4)
                            {
                                snek._dir[_length-1] = 2;                                
                            }

            }
            
            if (d==E){// if stick points right, go right
                
                        if (snek._dir[_length-1]!=3)
                            {
                                snek._dir[_length-1] = 1;                                
                            }
                
                }
                
            if (d==W){// if stick points left, go left
                
                        if (snek._dir[_length-1]!=1)
                            {
                                snek._dir[_length-1] = 3;
                            }
                
                
                }
                
            if (d==S){// if stick points down, go down 
                
                        if (snek._dir[_length-1]!=2)
                            {
                                snek._dir[_length-1] = 4;
                            }
                
                
                }
        
            printf("updated ");
            addPoint();
        }//live loop
}//end of update

void Snake::addPoint(){
    
    posXY foodPos = _food.returnPos();
    if(snek._x[_length-1]==foodPos.x && snek._y[_length-1]== foodPos.y)
        {
            snek._x[_length+1]=snek._x[_length];//-1
            snek._y[_length+1]=snek._y[_length];
            snek._dir[_length+1]=snek._dir[_length-1];
            _length=_length+1;//if head == food, _length++
            _food.respawn();//spawn new food
        }
}//end of addPoint

void Snake::deadSnake(N5110 &lcd){
        
       
        live--; //take a life away
        while (live==0){//dead reset game
            lcd.clear();
            lcd.printString("Game Over",0,1);
            lcd.printString("Press Reset",0,2);
            lcd.printString("To restart",0,3);
            lcd.refresh(); 
          
        }
                //lcd.clear();
        //lcd.printString("Game Over",0,1);
        //lcd.refresh();    
        
        init(startx,starty,startl,live);
        
}//end of deadSnake
        
void Snake::checkWallCollision(N5110 &lcd){
    
    if (snek._x[_length]==WIDTH||snek._x[_length]==0)//if snake head hits side walls
        {     
            deadSnake(lcd);
        }
    if (snek._y[_length]==CEILING||snek._y[_length]==FLOOR)//if snake hits top or bottom walls
        {     
            deadSnake(lcd);
        }
    
}//end of checkWallCollision

void Snake::checkTailCollision(N5110 &lcd){//if snake eats itself
    for (int i=0 ;_length<i ;i++){
                                          
                    if (snek._x[_length-1]==snek._x[i] && snek._y[_length-1]==snek._y[i])
                        {
                            deadSnake(lcd);
                        }
                }
    
    
}//end of checkTailCollision

void Snake::drawScore(N5110 &lcd){
        char buffer1[14];
        char buffer2[14];
        sprintf(buffer1,"%2d",live);
        sprintf(buffer2,"%2d",_length-5);
        lcd.printString(buffer1,25,0);
        lcd.printString(buffer2,70,0);
        lcd.printString("Life:",0,0);
        lcd.printString("Pts:",40,0);//display life and points
    
}//end of drawScore