
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Background.h"



struct UserInput {
    Direction d;
    float mag;
};

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Background back;

void init();
void update_game(UserInput input);
void render();
void welcome();

int main()
{
    int fps = 8;  

    init();
    welcome();
    
    render();  
    wait(1.0f/fps);  

   
    while (1) {
        back.read_input(pad);
        back.update(pad,lcd);
        render();
        wait(1.0f/fps);
    }
}

void init()
{
    lcd.init();
    pad.init();
     
   back.init();

}

void render()
{
 
    lcd.clear();  
    back.draw(lcd);
    lcd.refresh();
}

void welcome() {
    
    lcd.printString("     MAZE    ",0,2);  
    lcd.printString("  Press Start ",0,5);
    lcd.refresh();
     
  
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.3);
        pad.leds_off();
        wait(0.2);
    }
 
}