// pre-processor directives //
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "hole.h"
#include "human.h"
#include "interface.h"


// objects //
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
hole Blackhole;
human person;
interface Interface;

// prototypes //
void bool_check();
void A_bomb();
void B_bomb();
void X_bomb();
void Y_bomb();
void end();
void welcome();
void succeed();

// functions //
void welcome() {
    
    lcd.printString("     Bomb!    ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}

int main()
{
    double x;
    double y;
    
    lcd.init();
    pad.init();
    lcd.clear();
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(0.5); // put LED backlight on 50%
    
    Blackhole.hole_place();
    
    //printf("First stage\n");
        
    welcome();


    while (1) {        

        int four = ((rand())%4)+1; //produce a number between 1 to 4
        printf("%i\n", four);
        /*@param x - the width of human
         *@param y - the length of human*/
        x = person.humanX();
        //printf("Pass one ");
        y = person.humanY();
        //printf("Pass two");
        person.print_human();
        
        Blackhole.hole_show();
        lcd.refresh();
        lcd.clear();

        
        printf("check 1\n");
        bool check = Blackhole.test(x,y);
        printf("%i\n",four);
        pad.check_event(Gamepad::A_PRESSED) == false;
        pad.check_event(Gamepad::B_PRESSED) == false;
        pad.check_event(Gamepad::X_PRESSED) == false;
        pad.check_event(Gamepad::Y_PRESSED) == false;
        if( pad.check_event(Gamepad::R_PRESSED) == true && check )
        {
            //four cases about which button is bomb      
            switch (four){
                 
                case 1 : printf ("bomb_A\n");
                         A_bomb();
                         break;
                        
                case 2 : printf ("bomb_B");
                         B_bomb();
                         break;
                        
                case 3 : printf ("bomb_X");
                         X_bomb();
                         break;
                        
                case 4 : printf ("bomb_Y");
                         Y_bomb();
                         break;
                }
            
            
        } 
        lcd.refresh();
        lcd.clear(); 
    }

}

void bool_check()
{

}

void A_bomb() //when button A is bomb, press A game is over
{
    bool first = true;
    bool second = true;
    bool third = true;
    bool fourth = true;
    
    bool check1 = false;
    bool check2 = false;
    bool check3 = false;

    bool_check();
    while(1)
        {
            if(pad.check_event(Gamepad::B_PRESSED) == true)
            {
                second = false;
                check1 = true;
            }
            else if(pad.check_event(Gamepad::X_PRESSED) == true)
            {
                third = false;
                check2 = true;
                printf("X is pressed");
            }
            else if(pad.check_event(Gamepad::Y_PRESSED) == true)
            {
                fourth = false;
                check3 = true;
            }
            else if(pad.check_event(Gamepad::A_PRESSED) == true) // bomb  A
            {
                end();
            }   
            lcd.refresh();
            lcd.clear();                       
            if(first)
            {                
                Interface.A();
            }
            if(second)
            {
                Interface.B(); 
            }
            if(third)
            {
                Interface.X();   
            }
            if(fourth)
            {
                Interface.Y();
            }
            if(check1 && check2 && check3)
            {
                succeed();   
            }
            Interface.border();
            lcd.refresh();
            lcd.clear(); 
        } // end of A press
}


void B_bomb() // when botton B is bomb, press B game is over
{
    bool first = true;
    bool second = true;
    bool third = true;
    bool fourth = true;
    
    bool check1 = false;
    bool check2 = false;
    bool check3 = false;

    bool_check();
    while(1)
        {
            if(pad.check_event(Gamepad::A_PRESSED) == true)
            {
                second = false;
                check1 = true;
            }
            else if(pad.check_event(Gamepad::X_PRESSED) == true)
            {
                third = false;
                check2 = true;
                printf("X is pressed");
            }
            else if(pad.check_event(Gamepad::Y_PRESSED) == true)
            {
                fourth = false;
                check3 = true;
            }
            else if(pad.check_event(Gamepad::B_PRESSED) == true) // bomb  B
            {
                end();
            }   
            lcd.refresh();
            lcd.clear();                       
            if(first)
            {                
                Interface.B();
            }
            if(second)
            {
                Interface.A();
            }
            if(third)
            {
                Interface.X();    
            }
            if(fourth)
            {
                Interface.Y();
            }
            if(check1 && check2 && check3)
            {
                succeed();   
            }
            Interface.border();
            lcd.refresh();
            lcd.clear(); 
        } // end of B press 
}

void X_bomb() //when botton X is bomb, press X game is over
{
    bool first = true;
    bool second = true;
    bool third = true;
    bool fourth = true;
    
    bool check1 = false;
    bool check2 = false;
    bool check3 = false;

    bool_check();
    while(1)
        {
            if(pad.check_event(Gamepad::A_PRESSED) == true)
            {
                second = false;
                check1 = true;
            }
            else if(pad.check_event(Gamepad::B_PRESSED) == true)
            {
                third = false;
                check2 = true;
                printf("B is pressed");
            }
            else if(pad.check_event(Gamepad::Y_PRESSED) == true)
            {
                fourth = false;
                check3 = true;
            }
            else if(pad.check_event(Gamepad::X_PRESSED) == true) // bomb  X
            {
                end();
            }   
            lcd.refresh();
            lcd.clear();                       
            if(first)
            {                
                Interface.X();
            }
            if(second)
            {
                Interface.A();
            }
            if(third)
            {
                Interface.B();   
            }
            if(fourth)
            {
                Interface.Y();
            }
            if(check1 && check2 && check3)
            {
                succeed();   
            }
            Interface.border();
            lcd.refresh();
            lcd.clear(); 
        } // end of X press
}

void Y_bomb() // when botton Y is bomb, press Y game is over
{
    bool first = true;
    bool second = true;
    bool third = true;
    bool fourth = true;
    
    bool check1 = false;
    bool check2 = false;
    bool check3 = false;

    bool_check();
    while(1)
        {
            if(pad.check_event(Gamepad::A_PRESSED) == true)
            {
                second = false;
                check1 = true;
                printf("A is pressed");
            }
            else if(pad.check_event(Gamepad::B_PRESSED) == true)
            {
                third = false;
                check2 = true;
            }
            else if(pad.check_event(Gamepad::X_PRESSED) == true)
            {
                fourth = false;
                check3 = true;
            }
            else if(pad.check_event(Gamepad::Y_PRESSED) == true) // bomb  Y
            {
                end();
            }   
            lcd.refresh();
            lcd.clear();                       
            if(first)
            {                
                Interface.Y();
            }
            if(second)
            {
                Interface.A();
            }
            if(third)
            {
                Interface.B();   
            }
            if(fourth)
            {
                Interface.X();
            }
            if(check1 && check2 && check3)
            {
                succeed();   
            }
            Interface.border();
            lcd.refresh();
            lcd.clear(); 
        } // end of Y press
}

 void end()//press the wrong button
{
     pad.tone(800.0, 1);
     // wait flashing LEDs until back button is pressed
     pad.check_event(Gamepad::BACK_PRESSED) == false;
     while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
     pad.leds_on();
     wait(0.1);
     pad.leds_off();
     wait(0.1);
    
     lcd.printString("   Game Over    ",0,2);
     lcd.refresh();
     lcd.clear();
     }
     main();
}

void succeed() //press three right button
{
    lcd.refresh();
    lcd.clear();
    // wait flashing LEDs until back button is pressed
    pad.check_event(Gamepad::BACK_PRESSED) == false;
    while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
    pad.leds_on();
    wait(0.1);
    pad.leds_off();
    wait(0.1);
    
    lcd.printString("Congratulation",0,2);
    lcd.refresh();
    lcd.clear();
     }
     main();
     
}



            