#ifndef RECTANGLE_H
#define RECTANGLE_H 

#include "mbed.h"

/**Rectangle class
@brief Abstract class that defines collision between rectangles
@author Lev Duman
@date May 4 2017
*/
class Rectangle 
{
    public:
        /**Coollion to the north*/
        bool collisionLeftUpN(Rectangle a);
        /**Coollion to the south*/
        bool collisionLeftUpS(Rectangle a);
        /**Coollion to the west*/
        bool collisionLeftUpW(Rectangle a);
        /**Coollion to the east*/
        bool collisionLeftUpE(Rectangle a);
        /**Coollion to the north*/
        bool touchLeftDownN(Rectangle a);
        /**Coollion to the south*/
        bool touchLeftDownS(Rectangle a);
        /**Coollion to the west*/
        bool touchLeftDownW(Rectangle a);
        /**Coollion to the east*/
        bool touchLeftDownE(Rectangle a);
        int getX();
        int getY();
        int getWidth();
        int getHeight();
    protected:
        int x;
        int y;
        int height;
        int width;
};
#endif