#include "Character.h"
#include "N5110.h"
#include "mbed.h"
#include "Enemy.h"
//Serial pc(USBTX, USBRX);

//Constructor
Character::Character(int x, int y)
{
    this->x=x;
    this->y=y;
    width=8;
    height=10;
    force=0.0f;
    floatY=0.0f;
}

//Destructor
Character::~Character()
{
    
}

//////////////DRAW - CHARACTER//////////////////////////////////////////////////
/**
@details Handles character drawing on the screen 
*/
void Character::draw(N5110 &lcd, int absoluteCoord, bool white )
{
    white = !white;
    //pc.printf("%d\n",x);
    //pc.printf("%d\n",y);
    //head
    lcd.setPixel(x-absoluteCoord,y-9, white);
    lcd.setPixel(x+1-absoluteCoord,y-9, white);
    lcd.setPixel(x+2-absoluteCoord,y-9, white);
    lcd.setPixel(x+3-absoluteCoord,y-9, white);
    lcd.setPixel(x+4-absoluteCoord,y-9, white);
    lcd.setPixel(x+1-absoluteCoord,y-8, white);
    lcd.setPixel(x+2-absoluteCoord,y-8, white);
    lcd.setPixel(x+4-absoluteCoord,y-8, white);
    lcd.setPixel(x+2-absoluteCoord,y-7, white);
    lcd.setPixel(x+3-absoluteCoord,y-7, white);
    lcd.setPixel(x+4-absoluteCoord,y-7, white);
       
    //body
    lcd.setPixel(x+1-absoluteCoord,y-6, white);
    lcd.setPixel(x+2-absoluteCoord,y-6, white);
    lcd.setPixel(x+3-absoluteCoord,y-6, white);
    lcd.setPixel(x+5-absoluteCoord,y-6, white);
    lcd.setPixel(x+6-absoluteCoord,y-6, white);
    lcd.setPixel(x+7-absoluteCoord,y-6, white);
    lcd.setPixel(x+1-absoluteCoord,y-5, white);
    lcd.setPixel(x+2-absoluteCoord,y-5, white);
    lcd.setPixel(x+3-absoluteCoord,y-5, white);
    lcd.setPixel(x+4-absoluteCoord,y-5, white);
    lcd.setPixel(x+5-absoluteCoord,y-5, white);
    lcd.setPixel(x+2-absoluteCoord,y-4, white);
    lcd.setPixel(x+3-absoluteCoord,y-4, white);
    lcd.setPixel(x+2-absoluteCoord,y-3, white);
    lcd.setPixel(x+3-absoluteCoord,y-3, white);
       
    //legs
    lcd.setPixel(x+1-absoluteCoord,y-2, white);
    lcd.setPixel(x+4-absoluteCoord,y-2, white);
    lcd.setPixel(x+1-absoluteCoord,y-1, white);
    lcd.setPixel(x+4-absoluteCoord,y-1, white);
    lcd.setPixel(x+1-absoluteCoord,y, white);
    lcd.setPixel(x+2-absoluteCoord,y, white);
    lcd.setPixel(x+4-absoluteCoord,y, white);
    lcd.setPixel(x+5-absoluteCoord,y, white);
}
//////////////CHARACTERORENEMYDEATH - CHARACTER//////////////////////////////////////////////////
/**
@details function that decides does enemy or character dies
*/
void Character::characterOrEnemyDeath(deque<Enemy*>* enemyMap)
{
    if(force<0)
    {
        deque<Enemy*>::iterator it;
        //enemy death
        if((it = collisionEnemyS(enemyMap))!= enemyMap->end())
        {
            enemyMap->erase(it);
            force=0.73;
        }
    }
    //character death 
    if(collisionEnemyW(enemyMap)||collisionEnemyE(enemyMap)||collisionEnemyN(enemyMap))
    {
        x=-20;
        y=48;
    }
}
//////////////RISE - CHARACTER//////////////////////////////////////////////////
/**
@details Function that handles character jumping and acceleration during jump 
*/
void Character::rise(deque<Platform*>* levelMap)
{
    if (collisionPlatformN(levelMap))
    {
        //pc.printf("%d",y);
        force=-0.4f;
    }
    if(force>0.0f)
    {
        floatY-=force;
        force-=0.11f;   
        y=floor(floatY+0.5f);
    }
}

//////////////FALL - CHARACTER//////////////////////////////////////////////////
/**
@details Function that handles character falling after the jump
*/
void Character::fall(deque<Platform*>* levelMap)
{
    if (collisionPlatformS(levelMap))
    {
        force=0.0f;
    }
    if(force<0.0f)
    {
        floatY-=force;
        if(force>-1)
        {
            force-=0.11f;
        }
        y=floor(floatY+0.5f);    
    }
}

//////////////RISE - CHARACTER//////////////////////////////////////////////////
/**
@details Function that handles character movement
*in addition it increases absolute coordinate of the screen
*/
void Character::movement(Direction d, int* absoluteCoord, deque<Platform*>* levelMap, deque<Enemy*>* enemyMap)
{
    //pc.printf("%d\n",*absoluteCoord);
    //pc.printf("move right \n");
    if ((d==E)||(d==NE))
    {
        //pc.printf("move right \n");
        if (!collisionPlatformE(levelMap))
        {
            x++;
            if((x-(*absoluteCoord))>(28-width/2))
            {
                (*absoluteCoord)++;
                //pc.printf("%d\n", (*absoluteCoord));
            }
        }
    }
    else if (((d==W)||(d==NW))&&((x-*absoluteCoord)>0))
    {
        if (!collisionPlatformW(levelMap))
        {
            x--;
        }
    }
    if(force==0.0f)
    {
        if ((d==NW)||(d==N)||(d==NE))
        {
            force=1.5f;
            floatY=y;
        }
    }
    noPlatformFall(levelMap);
    rise(levelMap);
    fall(levelMap);
    characterOrEnemyDeath(enemyMap);
}

//////////////NOPLATFORMFALL - CHARACTER//////////////////////////////////////////////////
/**
@details implements falling donw when character walks off the platform 
*/
void Character::noPlatformFall(deque<Platform*>* levelMap)
{
    if((!collisionPlatformS(levelMap)) && (force==0.0f))
    {
        force=-0.04f;   
        floatY=y; 
    }
}

//////////////COLLISIONPLATFORME - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision to the right of the character with each platform
*/
bool Character::collisionPlatformE(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpE(*p))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONPLATFORMW - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision to the left of the character with each platform
*/
bool Character::collisionPlatformW(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpW(*p))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONPLATFORMS - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision bellow the character with each platform
*/
bool Character::collisionPlatformS(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpS(*p))
        {
            //pc.printf("ychar - %d\n", y);
            //pc.printf("y-heightplatf - %d", p->getY() - p->getHeight());
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONPLATFORMN - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision above the character with each platform
*/
bool Character::collisionPlatformN(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpN(*p))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONENEMYE - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision to the right of the character with each enemy
*/
bool Character::collisionEnemyE(deque<Enemy*>* enemyMap)
{
    for(deque<Enemy*>::iterator it=enemyMap->begin(); it !=enemyMap->end();)
    {
        Enemy* e=*it;
        if (touchLeftDownE(*e))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONENEMYW - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision to the left of the character with each enemy
*/
bool Character::collisionEnemyW(deque<Enemy*>* enemyMap)
{
    for(deque<Enemy*>::iterator it=enemyMap->begin(); it !=enemyMap->end();)
    {
        Enemy* e=*it;
        if (touchLeftDownW(*e))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONENEMYS - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision bellow the character with each enemy
*/
deque<Enemy*>::iterator Character::collisionEnemyS(deque<Enemy*>* enemyMap)
{
    for(deque<Enemy*>::iterator it=enemyMap->begin(); it !=enemyMap->end();)
    {
        Enemy* e=*it;
        if (touchLeftDownS(*e))
        {
            return it;
        }
        it++;
    }
    return enemyMap->end();
}

//////////////COLLISIONENEMYN - CHARACTER//////////////////////////////////////////////////
/**
@details Function that checks collision above the character with each enemy
*/
bool Character::collisionEnemyN(deque<Enemy*>* enemyMap)
{
    for(deque<Enemy*>::iterator it=enemyMap->begin(); it !=enemyMap->end();)
    {
        Enemy* e=*it;
        if (touchLeftDownN(*e))
        {
            return true;
        }
        it++;
    }
    return false;
}