#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include <deque>
#include "Platform.h"
#include "Map.h"
#include "Character.h"
#include "Enemy.h"

//Serial pc(USBTX, USBRX);

//create lcd object
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
//create gamepad object
Gamepad pad;

//create timer object
Timer t;

// booleans for win/loose/start conditions
bool win = false;
bool loose = false;
bool start = false;

//function to initialise everything needed
void init()
{
    //Initialise gamepad and LCD
    lcd.init();
    pad.init();
}

//function that displays welcoming screen 
void welcome()
{
   lcd.printString("Welcome",20,1);
   lcd.refresh();
   pad.leds_on();
   wait(2.0);
   lcd.clear();
}

//function that displays press start
void pressStart()
{
   lcd.printString("Press start",10,1);
   lcd.printString("to begin",15,3);
   lcd.refresh();
   pad.leds_off();
}

//function that displays game over screen 
void gameOver()
{
    lcd.printString("Game Over",17,1);
    lcd.refresh(); 
    wait(1.0);
    lcd.clear();   
}

//function do display win screen
void winner()
{
    lcd.printString("You Won",20,1);
    lcd.refresh();
    wait(4.0);
    lcd.clear();    
}

// function to create platform list
deque<Platform*>* createLevel()
{
    //declare new queue named levelMap
    deque <Platform*>* levelMap = new deque<Platform*>;
    //create new platform
    Platform* p = new Platform(0,44,30,3,FILL_BLACK);
    //insert new platofrm into queue
    levelMap->push_back(p);
     //create new platform
    //p = new Platform(40,37,10,3,FILL_BLACK);
    //insert new platofrm into queue
    //levelMap->push_back(p);
     //create new platform
    p = new Platform(40,35,10,3,FILL_BLACK);
    //insert new platofrm into queue
    levelMap->push_back(p);
    p = new Platform(70,44,40,3,FILL_BLACK);
    //insert new platofrm into queue
    levelMap->push_back(p);
    p = new Platform(70,41,3,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(130,44,50,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(130,41,3,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(177,41,3,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(190,30,10,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(230,44,30,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(260,35,20,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(290,25,20,3,FILL_BLACK);
    levelMap->push_back(p);
    p = new Platform(230,41,3,3,FILL_BLACK);
    levelMap->push_back(p);
      
    return levelMap;
}

// function to create enemy list
deque<Enemy*>* createEnemies()
{
    //declare new queue named enemyMap
    deque <Enemy*>* enemyMap = new deque<Enemy*>;
    //create new enemy
    Enemy* e = new Enemy(105,43);
    //insert new enemy into queue
    enemyMap->push_back(e);
    //create new enemy
    e = new Enemy(140,43);
    //insert new enemy into queue
    enemyMap->push_back(e);
    e = new Enemy(250,43);
    enemyMap->push_back(e);
    e = new Enemy(270,43);
    enemyMap->push_back(e);
    e = new Enemy(30,43);
    enemyMap->push_back(e);
          
    return enemyMap;
}

int main()
{
    init();
    //clear lcd
    lcd.clear();
    Direction d;
    int lastAction=-50;
    int monsterMove=-100;
    //reset timer
    t.reset();
    //start timer
    t.start();
    //welcome screen 
    welcome();
    while(true)
    {
        pressStart();
        while(!start)
        {
            if(pad.check_event(pad.START_PRESSED))
            {
                start=true;   
            }
        }
        //create map object
        Map map1(createLevel(), createEnemies(), new Character(5,40));
        start=false;
        //clear lcd
        lcd.clear();
        //draw buffer to screen 
        lcd.refresh();
        
        //game loop
        while(!win && !loose)
        {
            if((t.read_ms()-lastAction)>50)
            {
                lastAction=t.read_ms();
                //get direction from joystick
                d = pad.get_direction();
                //draw map
                map1.draw(lcd, true);
                //if((t.read_ms()-monsterMove)>100)
                //{
                    monsterMove=t.read_ms();
                    //move all enemies 
                    map1.moveEnemies();
                //}
                //mov and draw characters
                map1.getCharacter()->movement(d, map1.getAbsoluteCoord(), map1.getLevelMap(), map1.getEnemyMap());
                //loosing condition
                if ((map1.getCharacter()->getY()>47) || pad.check_event(pad.BACK_PRESSED))
                {
                    loose=true;
                    wait(0.3);
                }
                //clear map
                else
                {
                    map1.draw(lcd, false);
                }
                //wining condition
                if (map1.getCharacter()->getX()==300)
                {
                    win=true;   
                }
                //refresh screen 
                lcd.refresh();
            }
        }
        lcd.clear();
        lcd.refresh();
        //display loosing screen 
        if (loose)
        {
            gameOver();  
        }
        //display wining screen 
        else
        {
           winner();         
        }
        //reset booleans
        win=false;
        loose=false;
    }
}