#include "Map.h"
#include <deque>
#include "Gamepad.h"
#include "Platform.h"
#include "Enemy.h"
#include "Character.h"
#include "N5110.h"
Serial pc(USBTX, USBRX);

//constructor
Map::Map(deque<Platform*>* levelMap, deque<Enemy*>* enemyMap, Character* character)
:levelMap(levelMap), enemyMap(enemyMap), character(character)
{
    absoluteCoord = 0;
}

Map::~Map()  //destructor
{

}

///////////////DRAW - MAP///////////////////////////////////////////////////////
/**
*@details  handles drawing of platforms, characters and enemies based on changing coordinates,
*in addition deletes platofrms, and enemies that are unreachable
*(map doesn't scroll left)
*/
void Map::draw(N5110 &lcd, bool white)
{
    //pc.printf("%d\n", absoluteCoord)
    //pc.printf("drawing started");
    character->draw(lcd, absoluteCoord, white);
    //pc.printf("character finished drawing");
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
       Platform* p=*it;
        if (((p->getX()+p->getWidth()-1-absoluteCoord)>=0)&&((p->getX()-absoluteCoord)<84))
        {
            p->draw(lcd, absoluteCoord, white); 
            it++;  
        }
        else if ((p->getX()+p->getWidth()-1-absoluteCoord)<0)
        {
            levelMap->erase(it);   
            it=levelMap->begin(); 
        }
        else
        {
            it++;
        }
    }
    //pc.printf("Pre-cycle!");
    for(deque<Enemy*>::iterator it=enemyMap->begin(); it !=enemyMap->end();)
    {
        Enemy* e=*it;
        //pc.printf("Inside cycle! %d\n", it);
        if (((e->getX()+e->getWidth()-1-absoluteCoord)>=0)&&((e->getX()-absoluteCoord)<84))
        {
            e->setSpawned(true);
            //pc.printf("Drawing enemy!");
            e->draw(lcd, absoluteCoord, white); 
            it++;  
        }
        else if ((e->getX()+e->getWidth()-1-absoluteCoord)<0)
        {
            //pc.printf("Deleting enemy!");
            enemyMap->erase(it);   
            it=enemyMap->begin(); 
        }
        else
        {
            it++;   
        } 
    } 
    //pc.printf("Past cycle!");
}
///////////////MOVEENEMIES - MAP///////////////////////////////////////////////////////
/**
*@details function that handles enemy movement
*/
void Map::moveEnemies()
{
    for(deque<Enemy*>::iterator it=enemyMap->begin(); it !=enemyMap->end();)
    {
        Enemy* e=*it;
        if(e->getSpawned())
        {
            if(e->movement(absoluteCoord, levelMap))
            {
                enemyMap->erase(it);   
                it=enemyMap->begin();
            }
            else
            {
                it++; 
            }
        }
        else
        {
            it++;   
        }
    }
}

int* Map::getAbsoluteCoord()
{
    return &absoluteCoord;
}

Character* Map::getCharacter()
{
    return character;
}

deque<Platform*>* Map::getLevelMap()
{
    return levelMap;
}

deque<Enemy*>* Map::getEnemyMap()
{
    return enemyMap;
}