#include "Enemy.h"
#include "N5110.h"
#include "mbed.h"
#include "math.h"
#include "Platform.h"
//Serial pc(USBTX, USBRX);

Enemy::Enemy(int x, int y)
{
    this->x=x;
    this->y=y;
    width=8;
    height=7;
    force=0.0f;
    floatY=0.0f;
    directionW=true;
    spawned=false;
}

Enemy::~Enemy()
{
    
}

//////////////DRAW - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy drawing on the screen 
*/
void Enemy::draw(N5110 &lcd, int absoluteCoord, bool white )
{
    white = !white;
    //pc.printf("%d\n",x);
    //pc.printf("%d\n",y);
    //1st row
    lcd.setPixel(x-absoluteCoord+2,y-6, white);
    lcd.setPixel(x-absoluteCoord+3,y-6, white);
    lcd.setPixel(x-absoluteCoord+4,y-6, white);
    lcd.setPixel(x-absoluteCoord+5,y-6, white);
    //2nd row
    lcd.setPixel(x-absoluteCoord+1,y-5, white);
    lcd.setPixel(x-absoluteCoord+2,y-5, white);
    lcd.setPixel(x-absoluteCoord+3,y-5, white);
    lcd.setPixel(x-absoluteCoord+4,y-5, white);
    lcd.setPixel(x-absoluteCoord+5,y-5, white);
    lcd.setPixel(x-absoluteCoord+6,y-5, white);
    //3rd row
    lcd.setPixel(x-absoluteCoord,y-4, white);
    lcd.setPixel(x-absoluteCoord+1,y-4, white);
    
    lcd.setPixel(x-absoluteCoord+3,y-4, white);
    lcd.setPixel(x-absoluteCoord+4,y-4, white);
    
    lcd.setPixel(x-absoluteCoord+6,y-4, white);
    lcd.setPixel(x-absoluteCoord+7,y-4, white);
    
    //4th row
    lcd.setPixel(x-absoluteCoord,y-3, white);
    
    lcd.setPixel(x-absoluteCoord+2,y-3, white);
    lcd.setPixel(x-absoluteCoord+3,y-3, white);
    lcd.setPixel(x-absoluteCoord+4,y-3, white);
    lcd.setPixel(x-absoluteCoord+5,y-3, white);
    
    lcd.setPixel(x-absoluteCoord+7,y-3, white);
    //5th row
    lcd.setPixel(x-absoluteCoord,y-2, white);
    lcd.setPixel(x-absoluteCoord+1,y-2, white);
    lcd.setPixel(x-absoluteCoord+2,y-2, white);
    lcd.setPixel(x-absoluteCoord+3,y-2, white);
    lcd.setPixel(x-absoluteCoord+4,y-2, white);
    lcd.setPixel(x-absoluteCoord+5,y-2, white);
    lcd.setPixel(x-absoluteCoord+6,y-2, white);
    lcd.setPixel(x-absoluteCoord+7,y-2, white);
    //6th row
    
    lcd.setPixel(x-absoluteCoord+1,y-1, white);
    lcd.setPixel(x-absoluteCoord+2,y-1, white);
    
    lcd.setPixel(x-absoluteCoord+4,y-1, white);
    lcd.setPixel(x-absoluteCoord+5,y-1, white);
    
    //7th row
    lcd.setPixel(x-absoluteCoord,y, white);
    
    
    
    
    
    
    lcd.setPixel(x-absoluteCoord+7,y, white);
}

//////////////MOVEMENT - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy movement on the screen 
*/
bool Enemy::movement(int absoluteCoord, deque<Platform*>* levelMap)
{
    if(directionW)
    {   
        if(collisionPlatformW(levelMap))
        {
            directionW=false;   
        }
        else
        {
            x--;
        }
    }
    else
    {
        if(collisionPlatformE(levelMap))
        {
            directionW=true;   
        }
        else
        {
            x++;
        }
    }
    noPlatformFall(levelMap);
    fall(levelMap);
    
    if(y>(47+height))
    {
        return true;
    }
    return false;
}

//////////////NOPLATFORMFALL - ENEMY//////////////////////////////////////////////////
/**
@details implements falling donw when enemy walks off the platform 
*/
void Enemy::noPlatformFall(deque<Platform*>* levelMap)
{
    if((!collisionPlatformS(levelMap)) && (force==0.0f))
    {
        force=-0.04f;   
        floatY=y; 
    }
}

//////////////FAll - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy falling gravity aspect
*/
void Enemy::fall(deque<Platform*>* levelMap)
{
    if (collisionPlatformS(levelMap))
    {
        force=0.0f;
    }
    if(force<0.0f)
    {
        floatY-=force;
        if(force>-1)
        {
            force-=0.11f;
        }
        y=floor(floatY+0.5f);    
    }
}

//////////////COLLISIONPLATFORME - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy collision with platform to the right
*/
bool Enemy::collisionPlatformE(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpE(*p))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONPLATFORMW - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy collision with platform to the left
*/
bool Enemy::collisionPlatformW(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpW(*p))
        {
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONPLATFORMS - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy collision with platform bellow
*/
bool Enemy::collisionPlatformS(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpS(*p))
        {
            //pc.printf("ychar - %d\n", y);
            //pc.printf("y-heightplatf - %d", p->getY() - p->getHeight());
            return true;
        }
        it++;
    }
    return false;
}

//////////////COLLISIONPLATFORMN - ENEMY//////////////////////////////////////////////////
/**
@details Handles enemy collision with platform above
*/
bool Enemy::collisionPlatformN(deque<Platform*>* levelMap)
{
    for(deque<Platform*>::iterator it=levelMap->begin(); it !=levelMap->end();)
    {
        Platform* p=*it;
        if (collisionLeftUpN(*p))
        {
            return true;
        }
        it++;
    }
    return false;
}

bool Enemy::getSpawned()
{
    return spawned;
}

void Enemy::setSpawned(bool spawned)
{
    this->spawned=spawned;
}