///////// pre-processor directives ////////
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "GameEngine.h"
#include "MenuEngine.h"

/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Serial pc(USBTX, USBRX);
Gamepad pad;
GameEngine game;
MenuEngine menu;

///////////// prototypes ///////////////
void update_screen();
void welcome();
void menu_loop();
void game_loop();

///////////// functions ////////////////
int main()
{
    // Initialise the pad and the LCD screen
    lcd.init();
    pad.init();

    welcome();

    while(1)
    {
        menu_loop();
        game_loop();
    }
}

void welcome()
{
    // Variable that determines whether "Press START" is displayed
    bool showStart = true;

    // Loop until player presses START
    while (!pad.check_event(Gamepad::START_PRESSED))
    {
        // Clear screen and print out the title
        lcd.clear();
        lcd.printString("Escape", 5, 0);
        lcd.printString("is", 30, 1);
        lcd.printString("an", 35, 2);
        lcd.printString("Ellusion", 30, 3);

        // Show and hide "Press START every 0.5 seconds"
        if (showStart) {
            lcd.printString("Press START", 10, 5);
            showStart = false;
        }
        else {
            showStart = true;
        }

        // Update screen and wait until next animation frame
        lcd.refresh();
        wait(0.5);
    }
}

void menu_loop()
{
    // Initialise the menu with the last level played
    menu.init(game.get_level());

    // Loop until player exits the menu
    while (!menu.gameStarted)
    {
        menu.read_input(pad, pc);
        menu.update(pad, pc, lcd);
        menu.draw(lcd,pc);
        menu.check_finish(pad, lcd, pc);
        wait(1.0f/10.0f); // 10 fps
    }
}

void game_loop()
{
    // Initialise the game with the settings selected in the menu
    game.init(menu.selectedLevel, menu.soundIsOn, pad);

    // Loop until the player finishes or exits the game
    while (game.isActive)
    {
        game.read_input(pad,pc);
        game.update(pad, pc, lcd);
        game.draw(lcd);
        game.check_finish(pad, lcd);
        wait(1.0f/10.0f); // 10 fps
    }
}