#include "Player.h"

//////////// constructor ////////////
Player::Player()
{

}

//////////// destructor ////////////
Player::~Player()
{

}

//////////////// public methods ////////////////

void Player::init(intVector2D XY)
{
    _x = XY.x;
    _y = XY.y;

    _isDead = false;

    Vector2D velocity = {0.0f, 0.0f};
    _velocity = velocity;

    intVector2D points[8] = {
        {0,0}, {2,0}, // top
        {0,2}, {2,2}, // bottom
        {0,0}, {0,2}, // left
        {2,0}, {2,2}, // right
    };

    for (int i = 0; i < 8; i++) {
		collisionPoint[i] = points[i];
    };

    _isJumping = true;
}

void Player::draw(N5110 &lcd)
{
    // draw the player
    lcd.drawRect(_x, _y, 3, 3, FILL_TRANSPARENT);
}

void Player::update(float jx, Serial &pc, int lvl, bool theSwitch, Gamepad &pad, bool soundOn)
{
    // Set to player's horizontal velocity equal to joystick horizontal displacement
    if (jx < 0) {
        _velocity.x = int(jx*3.2f); // slightly bigger multiplier to make up for mechanical imbalance
    } else {
        _velocity.x = int(jx*3.0f);
    }

    // Jump if not already jumping, the jump key was pressed and it was released before
    if (_didReleaseJumpKey && !_isJumping && _didPressJump) {
        apply_jump(lvl, theSwitch);
        if (soundOn) pad.tone(523.25f, 0.1f); // play tone if sound is on
    }

    // If jump key released - set the flag
    if (!_didPressJump) {
        _didReleaseJumpKey = true;
    }

    apply_gravity(lvl, theSwitch);

    // Assume player is in the air to prevent jumping
    // If that's not true it will be set to false in collision detection
    _isJumping = true;
}

intVector2D Player::get_pos()
{
    // Return an 2D vector of player's position
    intVector2D p = {_x, _y};
    return p;
}

void Player::set_pos(intVector2D p)
{
    // Read the passed vector and set player's position
    _x = p.x;
    _y = p.y;
}

Vector2D Player::get_velocity()
{
    // Return a 2D vector of player's velocity
    Vector2D velocity = {_velocity.x, _velocity.y};
    return velocity;
}

void Player::set_velocity(Vector2D v)
{
    // Read the passed vector and set player's velocity
    _velocity = v;
}

void Player::reset_velocity()
{
    // Set both horizontal and vertical speeds to zero
    _velocity.x = 0;
    _velocity.y = 0;
}

void Player::apply_gravity(int lvl, bool theSwitch)
{
    // Apply constant acceleration in y-axis
    // Activating the switch on levels 2 and 3 inverts gravity
    if ((lvl == 2 || lvl == 3) && theSwitch == true) {
        _velocity.y -= GRAVITY;
    }
    else {
        _velocity.y += GRAVITY;
    }
}

void Player::apply_jump(int lvl, bool theSwitch)
{
    // Set and clear appropriate flags
    _isJumping = true;
    _didReleaseJumpKey = false;

    // Project the player in the air
    // Flipping the switch on levels 2 and 3 inverts gravity
    if ((lvl == 2 || lvl == 3) && theSwitch == true) {
        _velocity.y = -JUMPSPEED;
    }
    else {
        _velocity.y = JUMPSPEED;
    }
}