#ifndef LEVEL_H
#define LEVEL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "GameObject.h"

/** Level class
@brief Stores current level number and loads appropriate objects

@brief Revision 1.0

@author Aleksejs Sladzevskis
@date   3rd May 2017
*/

class Level
{
public:

    /** Constructor */
    Level();

    /** Destructor */
    ~Level();

    /** Level number */
    int number;

    /**
    * Load the type of the object (more info in GameObject.h)
    *@param object number of the object being requested
    */
    int load_type(int object);

    /** Load the x-coordinate of the requested object
    *@param object number of the object being requested
    */
    int load_x(int object);

    /** Load the y-coordinate of the requested object
    *@param object number of the object being requested
    */
    int load_y(int object);

    /** Load the width of the requested object
    *@param object number of the object being requested
    */
    int load_width(int object);

    /** Load the height of the requested object
    *@param object number of the object being requested
    */
    int load_height(int object);


private:

};
#endif