#ifndef GAMEOBJECT_H
#define GAMEOBJECT_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Constants */
#define OBJECTCOUNT 51
#define MENUOBJECTCOUNT 10

/** GameObject class
@brief Stores the parameters of on-screen objects

@brief Revision 1.0

@author Aleksejs Sladzevskis
@date   3rd May 2017
*/

class GameObject
{

public:

    /** Constructor */
    GameObject();

    /** Destructor */
    ~GameObject();

    /** Type of the object where:
    * 0 - Platform, 
    * 1 - Horizontal Spikes, 
    * 2 - Vertical Spikes, 
    * 3 - Door, 
    * 4 - Switch, 
    * 5 - Uncollected Coin, 
    * 6 - Collected Coin, 
    * 7 - Menu Box
    */
    int type; 

    /** Coordinates of object's top-left corner */
    intVector2D position;

    /** Object's width */
    int width;

    /** Object's height */
    int height;

    /** Check whether the object contains given point
    *@param x x-coordinate to check
    *@param y y-coordinate to check
    */
    bool containsPoint(int x, int y);

private:

    // Check x coordinate
    bool containsX(int _x);

    // Check y coordinate
    bool containsY(int _y);

};
#endif