#ifndef ANIMATION_H
#define ANIMATION_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Animation Class
@brief  A class for animating certain actions

@brief Revision 1.0

@author Aleksejs Sladzevskis
@date   3rd May 2017
*/

class Animation
{
public:
    /** Constructor */
    Animation();

    /** Destructor */
    ~Animation();

    /** Animate player's spawn
    *@param lcd for output
    *@param position where animation needs to happen
    */
    void spawn(N5110 &lcd, intVector2D starting_position);

    /** Animate player's death
    *@param lcd for output
    *@param position where animation needs to happen
    *@param frame the number of animation frame
    */
    void death(N5110 &lcd, intVector2D position, int frame);

    /** Animate player finishing the level
    *@param lcd for output
    *@param position where animation needs to happen
    *@param pad for sound output
    *@param sound to pass on current sound settings
    */
    void finish(N5110 &lcd, intVector2D position, Gamepad &pad, bool soundOn);

    /** A variable that allows animation to continue post-spawn by keeping count of the frame since spawning.
    Setting it to zero will trigger the animation */
    int spawnCycle;

private:


};
#endif