#include "Animation.h"

//////////// constructor ////////////
Animation::Animation()
{

}

//////////// destructor ////////////
Animation::~Animation()
{

}

/////////////////// public methods ///////////////////

void Animation::spawn(N5110 &lcd, intVector2D starting_position)
{
    // This animates the tube at the ceiling opening and the player falling out
    // of it, after which the tube closes.
    // The first animation cycle shows the player falling out of the tube
    // however we want the player to have control right after he appears,
    // rather than waiting for the tube opening to close. Hence the rest
    // of the animation will happen one frame at a time as the game goes on.
    if (spawnCycle == 0)
    {
        lcd.setPixel(starting_position.x + 1, starting_position.y - 1, false);
        lcd.refresh();
        wait(0.1);

        lcd.setPixel(starting_position.x, starting_position.y - 1, false);
        lcd.setPixel(starting_position.x + 2, starting_position.y - 1, false);
        lcd.refresh();
        wait(0.1);

        lcd.setPixel(starting_position.x - 1, starting_position.y - 1, false);
        lcd.setPixel(starting_position.x + 3, starting_position.y - 1, false);
        lcd.setPixel(starting_position.x, starting_position.y - 1);
        lcd.setPixel(starting_position.x + 2, starting_position.y - 1);
        lcd.setPixel(starting_position.x + 1, starting_position.y - 1);
        lcd.refresh();
        wait(0.1);

        lcd.setPixel(starting_position.x + 1, starting_position.y - 1, false);
        lcd.setPixel(starting_position.x, starting_position.y);
        lcd.setPixel(starting_position.x + 2, starting_position.y);
        lcd.setPixel(starting_position.x + 1, starting_position.y);
        lcd.refresh();
        wait(0.1);

        lcd.setPixel(starting_position.x + 1, starting_position.y - 1);
        lcd.setPixel(starting_position.x + 1, starting_position.y, false);
        lcd.setPixel(starting_position.x, starting_position.y + 1);
        lcd.setPixel(starting_position.x + 2, starting_position.y + 1);
        lcd.setPixel(starting_position.x + 1, starting_position.y + 1);
        lcd.refresh();
        wait(0.1);

        spawnCycle++;
    }
    else if (spawnCycle == 1)
    {
        lcd.setPixel(starting_position.x, starting_position.y - 1, false);
        lcd.setPixel(starting_position.x + 1, starting_position.y - 1, false);
        lcd.setPixel(starting_position.x + 2, starting_position.y - 1, false);
        spawnCycle++;
    }
    else if (spawnCycle == 2)
    {
        lcd.setPixel(starting_position.x + 1, starting_position.y - 1, false);
        spawnCycle++;
    }
}

void Animation::death(N5110 &lcd, intVector2D position, int frame)
{
    // Animates the explosion of the player due to hitting the spikes
    // The animation frame number is fed into the function
    // and the appropriate pixels are set or cleared.
    if (frame == 0)
    {
        lcd.setPixel(position.x + 1, position.y, false);
        lcd.setPixel(position.x, position.y + 1, false);
        lcd.setPixel(position.x + 1, position.y + 2, false);
        lcd.setPixel(position.x + 2, position.y + 1, false);
        lcd.setPixel(position.x + 1, position.y - 1);
        lcd.setPixel(position.x - 1, position.y + 1);
        lcd.setPixel(position.x + 1, position.y + 3);
        lcd.setPixel(position.x + 3, position.y + 1);
    }
    else if (frame == 1)
    {
        lcd.setPixel(position.x + 1, position.y - 1, false);
        lcd.setPixel(position.x - 1, position.y + 1, false);
        lcd.setPixel(position.x + 1, position.y + 3, false);
        lcd.setPixel(position.x + 3, position.y + 1, false);
        lcd.setPixel(position.x, position.y, false);
        lcd.setPixel(position.x + 2, position.y + 2, false);
        lcd.setPixel(position.x + 2, position.y, false);
        lcd.setPixel(position.x, position.y + 2, false);
        lcd.setPixel(position.x, position.y - 1);
        lcd.setPixel(position.x - 1, position.y);
        lcd.setPixel(position.x + 3, position.y);
        lcd.setPixel(position.x + 2, position.y - 1);
        lcd.setPixel(position.x - 1, position.y + 2);
        lcd.setPixel(position.x, position.y + 3);
        lcd.setPixel(position.x + 3, position.y + 2);
        lcd.setPixel(position.x + 2, position.y + 3);
    }
    else if (frame == 2)
    {
        lcd.setPixel(position.x, position.y - 1, false);
        lcd.setPixel(position.x - 1, position.y, false);
        lcd.setPixel(position.x + 3, position.y, false);
        lcd.setPixel(position.x + 2, position.y - 1, false);
        lcd.setPixel(position.x - 1, position.y + 2, false);
        lcd.setPixel(position.x, position.y + 3, false);
        lcd.setPixel(position.x + 3, position.y + 2, false);
        lcd.setPixel(position.x + 2, position.y + 3, false);
        lcd.setPixel(position.x, position.y - 2);
        lcd.setPixel(position.x - 2, position.y);
        lcd.setPixel(position.x + 4, position.y);
        lcd.setPixel(position.x + 2, position.y - 2);
        lcd.setPixel(position.x - 2, position.y + 2);
        lcd.setPixel(position.x, position.y + 4);
        lcd.setPixel(position.x + 4, position.y + 2);
        lcd.setPixel(position.x + 2, position.y + 4);
    }
    else if (frame == 3)
    {
        lcd.setPixel(position.x, position.y - 2, false);
        lcd.setPixel(position.x - 2, position.y, false);
        lcd.setPixel(position.x + 4, position.y, false);
        lcd.setPixel(position.x + 2, position.y - 2, false);
        lcd.setPixel(position.x - 2, position.y + 2, false);
        lcd.setPixel(position.x, position.y + 4, false);
        lcd.setPixel(position.x + 4, position.y + 2, false);
        lcd.setPixel(position.x + 2, position.y + 4, false);
    }
}

void Animation::finish(N5110 &lcd, intVector2D finish_position, Gamepad &pad, bool soundOn)
{
    // Animates the player going into the level exit tube. First 4 frames
    // also trigger a tone if the sound is turned on. 
    lcd.setPixel(finish_position.x + 3, finish_position.y + 2, false);
    lcd.refresh();
    if (soundOn) pad.tone(523.25f,0.1f);
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y + 1, false);
    lcd.refresh();
    if (soundOn) pad.tone(659.25f,0.1f);
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y, false);
    lcd.refresh();
    if (soundOn) pad.tone(784.0f,0.1f);
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y - 1, false);
    lcd.setPixel(finish_position.x + 3, finish_position.y + 2);
    lcd.setPixel(finish_position.x + 3, finish_position.y + 1);
    lcd.setPixel(finish_position.x + 3, finish_position.y);
    lcd.setPixel(finish_position.x + 2, finish_position.y + 1, false);
    lcd.setPixel(finish_position.x + 1, finish_position.y + 1);
    lcd.setPixel(finish_position.x, finish_position.y, false);
    lcd.setPixel(finish_position.x, finish_position.y + 1, false);
    lcd.setPixel(finish_position.x, finish_position.y + 2, false);
    lcd.refresh();
    if (soundOn) pad.tone(1046.5f,0.1f);
    wait(0.1);

    lcd.setPixel(finish_position.x + 1, finish_position.y, false);
    lcd.setPixel(finish_position.x + 1, finish_position.y + 1, false);
    lcd.setPixel(finish_position.x + 1, finish_position.y + 2, false);
    lcd.setPixel(finish_position.x + 2, finish_position.y + 1);
    lcd.setPixel(finish_position.x + 3, finish_position.y + 1, false);
    lcd.refresh();
    wait(0.1);

    lcd.setPixel(finish_position.x + 2, finish_position.y, false);
    lcd.setPixel(finish_position.x + 2, finish_position.y + 1, false);
    lcd.setPixel(finish_position.x + 2, finish_position.y + 2, false);
    lcd.setPixel(finish_position.x + 3, finish_position.y + 1);
    lcd.refresh();
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y, false);
    lcd.setPixel(finish_position.x + 3, finish_position.y + 1, false);
    lcd.setPixel(finish_position.x + 3, finish_position.y + 2, false);
    lcd.setPixel(finish_position.x + 3, finish_position.y - 1);
    lcd.refresh();
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y);
    lcd.refresh();
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y + 1);
    lcd.refresh();
    wait(0.1);

    lcd.setPixel(finish_position.x + 3, finish_position.y + 2);
    lcd.refresh();
    wait(0.1);
}