/**
@file main.cpp
@brief Car parking sensor system which uses audio and visual alerts to assist the user
@author Antonia Della Rocco
*/

// Allows access to all main.h information/data
#include "main.h"

/// Main function where sub functions are called
int main()
{

    g_inches == 0; // Set initial button value to 0
    button.mode(PullDown); // Set initial mode of button
    button.fall(&buttonUnits); // Check falling edge

    lcd.init(); // Initialise LCD screen
    intro(); /// Call introduction function
    wait (0.2);

    while(1) {

        getDistance(); /// Call distance function
        wait (0.2);
        indicatorLEDS(); /// Call LED function - realising I cannot set them flashing under different conditions as connected to same pin
        wait (0.2);
        buttonUnits(); /// Call button function
        wait (0.2);
        alertSound(); /// Call buzzer function
    }
}

/// Define all functions
/// Introduction function
void intro()
{

    lcd.printString("Antonia's",17,1);
    lcd.printString("Car Parking",8,2);
    lcd.printString("System",23,3);
    wait (1.0); // delay 1s for intro to be observed
    lcd.clear(); // clear lcd
}

/// Function - sensor measures distance, gets average, deducts error, saves to buffer, and prints to LCD screen, also records and displays temperature reading
void getDistance()
{

    /// additional buffers to confirm each calculation is working correctly - commented out once confirmed
//    char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
//    char bufferAll[14]; // buffer for average confirmation
//    char bufferInches[14]; // buffer for inches distance confirmation
    char bufferTemp[14]; // buffer for temperature display

    /// Create for loop to obtain average of 10 readings
    int sumOfReadings = 0; /// Create variable for sum of readings
    int n=0; // Iteration for n start at 0
    for ( n=0 ; n<10 ; n++ ) { /// For loop start at 0, increase by 1 until 9 for 10 readings in total
        int readings = srf02.getDistanceCm(); // Sensor measures distance
        sumOfReadings += readings; // Add each measured distance to the next
        wait(0.065); // Wait between readings
    }

    int averageDistance = (sumOfReadings / 10); /// Divide total distance by no of readings to get average
    int error = 17; /// Set margin of error for sensor is 17cm

    /// Stop calculated distance from going negative
    if (averageDistance < error)  {
        g_calcDistance = averageDistance;
    } else {
        g_calcDistance = averageDistance - error; // Calculate distance by taking away error from average distance
    }
    /// Get temperature reading
    float temp = tmp102.get_temperature();

    /// Convert calcuated distance to inches
    g_calcDistanceInches = g_calcDistance * 0.3937007874;

    lcd.printString("Distance =",0,0); // Display distance = 

    /// Read temperature, save to buffer and print to lcd
    float tempMemory = sprintf(bufferTemp, "T = %.2f C",temp); // saves temperature to buffer
    lcd.printString(bufferTemp,0,4); // displays temperature buffer on lcd

}

/// Set LEDS function to alert user visually if range is safe or dangerous
void indicatorLEDS()
{

    // If distance is less than/equal to 30cm red LED is ON
    if (g_calcDistance <= 30) {
        rLED = 0;
    }
    // If distance is more than 30cm red LED is OFF therefore green LED is ON
    else if (g_calcDistance > 30) {
        rLED = 1;
    }
}

/// Set buzzer function to alert user audibly if range is safe or dangerous
void soundAlert()
{

}

/// Set button function to aid user preference between metric/imperial distance when parking
void buttonUnits()
{
    g_inches++; // Increment unit variable by 1
    char buffer[14];  // Buffer for cm
    char bufferInches[14]; // Buffer for inches distance confirmation

    // Press button once adds one to display
    if (g_inches == 1) { 
        lcd.refresh(); // Refresh lcd so it can update after button is pressed
        float distanceInches = sprintf(bufferInches, "%.2f in",g_calcDistanceInches);
        lcd.printString(bufferInches,0,1);
    }
    // Press button again adds one to display 
    else if (g_inches == 2) {
        lcd.refresh();
        int distance_memory = sprintf(buffer, "%d cm",g_calcDistance); // saves distance to buffer
        lcd.printString(buffer,0,1);
        g_inches = 0; // Resets unit display back to beginning
    }
}

/// Set buzzer to alert user
void alertSound()
{
    buzzer.period(0.004545452);

    if (g_calcDistance <= 30) { /// Less than 30 cm high pitch
        buzzer.write(0.8);
    }
    else if (g_calcDistance > 30 && g_calcDistance <= 70) { // in between pitch
        buzzer.write(0.3);
        }
    else if (g_calcDistance > 70) // low pitch safer distance
        buzzer.write(0);
}
