/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Revision 1.0.
@author Antonia Della Rocco
@date   May 2016
*/

#ifndef MAIN_H
#define MAIN_H

#define PI 3.14159265359

// Access libraries for each device
#include "mbed.h" 
#include "SRF02.h"
#include "N5110.h"
#include "TMP102.h"

// Create objects for each device
/**
@namespace lcd
@brief mbed connection pins for  N5110
*/
N5110 lcd(PTE26,PTA0,PTC4,PTD0,PTD2,PTD1,PTC3); 

/**
@namespace srf02
@brief mbed connection pins for  SRF02
*/
SRF02 srf02(PTE25, PTE24); 

/**
@namespace tmp102
@brief mbed connection pins for  TMP102
*/
TMP102 tmp102(PTE25, PTE24); 

// Create objects for each output components and initialise
/**
@namespace rLED
@brief mbed pin for LEDs - rLED = active low (ON first), other LED active high therefore ON when rLED is OFF
*/
DigitalOut rLED(PTC2); 

/**
@namespace buzzer
@brief mbed connection pins for buzzer
*/
PwmOut buzzer(PTA2); 

// Create object for input component and initialise
/**
@namespace button
@brief mbed connection pins for button
*/
InterruptIn button(PTB18);

// Define global variables to be accessed in additional functions
/**
Global variable integer
Calculated distance (averages - error)
@param g_calcDistance 
*/
volatile int g_calcDistance; // global variable for calculated distance

/**
Global variable float
Calculated distance in inches
@param g_calcDistanceInches 
*/
volatile float g_calcDistanceInches; 

/**
Global variable integer
Unit display
@param g_inches 
*/
volatile int g_inches;

// Name & create functions
/**
Introduction to project function
@param intro()
*/
void intro(); 

/**
Calculate/display distance function - also records/displays temperature
@param getDistance()
*/
void getDistance();

/**
Set leds to let user know in they are in safe range
@param indicatorLEDS()
*/
void indicatorLEDS(); 

/**
Button function switches display between inches and cm
@param buttonUnits()
*/
void buttonUnits(); 

/**
Buzzer function alerts user when objects are too close
@param alertSound()
*/
void alertSound(); 

#endif