,
#include "mbed.h"
#include "N5110.h"

//vcc,sce,rst,dc,mosi,clk,led
N5110 lcd(p5,p6,p7,p8,p11,p13,p21); //pwm for led backlight
DigitalIn myswitch(p19); //creates function for the digitalIn switch which enables the switch to display glider or pixels (connects to pin 19 on mbed)
AnalogIn var(p17); // adds setting for using a potentiometer to adjust brightness of screen (connects to pin 16 on mbed)
                     // var = object name 
// note reset button should be pressed always when switch is flipped 

// function declaration
int cells[84][48]; // dimen
int n=0;
void namedisplay(); //calls function for name display on welcome screen
void clearCells(); //clears all cells on screen
void checkerBoard(); // checks that all the pixels are present on the screen
void checkcells(); //it checks and counts the neighbours and applies the rules
void updatecells(); // it updates the display for every generation
void menuDisplay(); 



void namedisplay()
{
    lcd.init();
    lcd.setBrightness(var); // sets the brightness for screen 
    lcd.printString("Welcome to" ,15,1); //inserts text for welcome on the first line hence the '1'
    lcd.printString("Conway's",20,2); // prints the text in the brackets on the secondline hence '2'
    lcd.printString("Game of Life",6,3); //prints text in the third line
    lcd.printString(" Thokozile",0,5); // prints name in fifth line
    wait(2); // delays for 2 seconds
    lcd.refresh(); // refreshes screen displays checkerboard (all pixels on screen)
    clearCells(); // clears screen removes cells
    lcd.refresh(); // resets the screen
}
void clearCells()
{
    //loop through cells and clear
    for (int i=0; i<84; i++) { // clears all the cells accross the screen horizontally
        for (int j=0; j<48; j++) { // clears all cells down the screen vertically
            lcd.clearPixel(i,j);
        }
    }
    lcd.refresh();
}
void glider()
{
    lcd.setPixel(20,20); 
    lcd.setPixel(21,20); 
    lcd.setPixel(22,20);
    lcd.setPixel(22,19);
    lcd.setPixel(21,18);
    
    //sets pixels to allow glider to move down and up
}
void checkerBoard()
{
    //loop through every other cell and turn pixel on
    for (int i=0; i<84; i+=2) { //loops through cells horizontally
        for (int j=0; j<48; j+=2) { //loops through cells vertically
            lcd.setPixel(i,j); //sets the pixels accordingly
        }
    }
    lcd.refresh(); //must refresh to write buffer to display
}

void checkcells()
{
    for (int i=0; i<84; i++) { // checks for neighbours in x-direction
        for (int j=0; j<48; j++) { // checks for neighbours in y-direction

            int n=0; //number of neighbours

            if(lcd.getPixel(i-1,j-1)) //pixel to top-left
                n++;
            if(lcd.getPixel(i-1,j)) //pixel to the left
                n++;
            if(lcd.getPixel(i-1,j+1)) //pixel to bottom left 
                n++;
            if(lcd.getPixel(i,j-1)) // pixel to top 
                n++;
            if(lcd.getPixel(i,j+1)) // pixel to bottom
                n++;
            if(lcd.getPixel(i+1,j-1)) // pixel to top-right
                n++;
            if(lcd.getPixel(i+1,j)) // pixel to right
                n++;
            if(lcd.getPixel(i+1,j+1)) // pixel to bottom-right
                n++;

            if (lcd.getPixel(i,j)) {  // if  cells are alive....
                if (n==3 || n==2)  // if n is 3 or 2
                    cells[i][j]=1; // switch cell on
                else if (n<2 || n>3) // if n is less than 2 or 3
                    cells[i][j]=0; // switch cell off
            } else { // else if dead...
                if (n==3)
                    cells[i][j]=1; // keep cell on
            }
        }
    }
}

void updatecells() // updates display for after checking neighbours
{
    lcd.setBrightness(var); // sets function to adjust brightness
   
    for(int i=0; i<84; i++) {  // updates for cells in x-direction
        for(int j=0; j<48; j++) { // updates for y-direction

            if(cells[i][j]==1) { //if cells are on
                lcd.setPixel(i,j); //set the pixels accordingly
            } else {
                lcd.clearPixel(i,j); // clear pixels when off
            }
        }
    }
    lcd.refresh(); //reset
}



int main() // main function to call all functions
{
    lcd.init(); 
    namedisplay();
    checkerBoard();
    wait(1.5);
    clearCells();
    wait(1.5);
    if (myswitch==1) {  // function for switch on 
        lcd.randomiseBuffer(); //randomise cells if swtich on
    } else if (myswitch==0) { // display glider on 2 and pixels on switch 1

        glider();
    }
    while(1) { // while loop
        checkcells();
        updatecells();
        wait(0.3); // the rate at which cells degenerate
        lcd.refresh();
    }
}
