/** Joystick Functions
* Used for reading and updating the joystick position and value for its button.
@file joystick.h
@brief
@brief
@author Craig Evans
@date April 2016
*/
#ifndef _JOYSTICK_H_

#define _JOYSTICK_H_

#define DIRECTION_TOLERANCE 0.25L // change this to alter tolerance of joystick direction
#include "mbed.h"
extern InterruptIn button;
extern AnalogIn xPot;
extern AnalogIn yPot;
extern DigitalIn Jbutton;
extern Ticker pollJoystick;

enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};



// function prototypes
extern void calibrateJoystick();
extern void updateJoystick();
extern Joystick return_data();

#endif