/** Menu Functions
@file main.h
@brief Contains global variables, function prototypes and menu code
*/
#ifndef _MAIN_H_

#define _MAIN_H_

#include "N5110.h"
#include "joystick.h"
#include "mbed.h"
#include "TMP102.h"
#include "beep.h"
#include <stdio.h>
#include <stdlib.h>

/**
@brief what it does
@author Ihsian Mulla
@date April 2016
*/


class MainFunctions
{
public:
    /** Contains the code for the introduction to the game
    */
    void Intro();
    /** Allows return to menu from game [prevents having to use NVIC_SystemReset
    */
    void SwitchMenu();
    /** writes the options as strings to the Nokia LCD screen
    */
    void MenuOptions();
    /**  functions to allow user interface to play snake
    */
    void Snake();
    /** functions to allow user interface to use etch-a-sketch (contains hidden mini game)
    */
    void Draw();
    /** Contains functions for the temperature snsor with variable unit conversion
    */
    void Temp();
    /**Clear 4 pixels for food
    */
    void button_isr();
    /**Allows the serial print of the Highscore array for testing
    */
    void error();


};

#endif