/** Temperature Sensor Functions
* Used for printing and updating the temperature at 1Hz with unit conversion capabilities
@file TempFunctions.cpp
@brief utilises unit conversion formulae within a while loop to allow for unit change.
@author Ihsian Mulla
@date April2016
*/

//---LIBRARIES--//
#include "mbed.h"
#include "beep.h"
#include "TMP102.h"
#include "N5110.h"
#include <stdio.h>
#include <stdlib.h>
#include "joystick.h"

extern Beep buzzer;
extern N5110 lcd;
extern Joystick joystick;

// Create TMP102 object
TMP102 tmp102(I2C_SDA,I2C_SCL);

// K64F on-board LEDs
DigitalOut re_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);

//Sets ticker to allow for timer
Ticker ticker1;

// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);
Serial pc(USBTX,USBRX);


int unit_select = 0; /*!< initialising first switch statement */
int selector =0; /*!< initialising pointer switch statement */
int next_unit_select = 0; /*!< used to confirm one transition per trigger on the joystick */

volatile int g_timer_flag = 0;

void timer_isr();// ticker function for temperature sensor
void error(); // error function hangs flashing an LED
void init_serial(); // setup serial port
void init_K64F(); // set-up the on-board LEDs and switches
void Temp(); // temperature code - finite state machine to transition between temperature units.
void SwitchMenu();//Allows return to menu from game [prevents having to use NVIC_SystemReset]

void Temp()
{
    lcd.init(); //  initialise lcd
    init_K64F();     // initialise the board
    init_serial(); // initialise the serial port
    tmp102.init(); //initialise the tmp102 sensor using dot syntax
    ticker1.attach(&timer_isr,1.0); // sets to read temp sensor at a frequency of 1Hz using a ticker
    lcd.normalMode();
    lcd.setBrightness(0.5); // put LED backlight on 50%


    while (1) {
        //change between units of temperature (Kelvin,Celcius,Farenheit)
        switch(unit_select) {
                // -- CELCIUS--//
            case 0:
                while(1) {
                    lcd.clear();
                    lcd.printString("Current",25,0);
                    lcd.printString("Temperature:",10,1);
                    lcd.drawCircle(63,30,1,0);
                    float T = tmp102.get_temperature();
                    char Temp1 [20];
                    sprintf(Temp1,"T = %2.2f  C",T);
                    lcd.printString (Temp1,2,4);
                    wait(0.1);
                    lcd.refresh();
                    if(joystick.direction==UP) {
                        selector=1;
                        break;
                    } else if(joystick.direction==DOWN) {
                        selector=2;
                        break;
                    } else {
                        selector=0;
                        break;
                    }
                }
//makes use of a switch statement within a switch statement to allow for joystick input to state transition
                switch(selector) {
                    case 0:
                        unit_select=3;
                        next_unit_select=0;
                        break;
                    case 1:
                        unit_select=3;
                        next_unit_select=2;
                        break;
                    case 2:
                        unit_select=3;
                        next_unit_select=1;
                        break;
                }
                break;
                //----Farenheit---//
            case 1:
                while(1) {
                    lcd.clear();
                    lcd.printString("Current",25,0);
                    lcd.printString("Temperature:",10,1);
                    lcd.drawCircle(63,30,1,0);
                    float T = tmp102.get_temperature();
                    char Temp2 [20];
                    sprintf(Temp2,"T = %2.2f  F",((T*1.8)+32));
                    lcd.printString (Temp2,2,4);
                    wait(0.1);
                    lcd.refresh();
                    if(joystick.direction==UP) {
                        selector=1;
                        break;
                    } else if(joystick.direction==DOWN) {
                        selector=2;
                        break;
                    } else {
                        selector=0;
                        break;
                    }
                }
                switch(selector) {
                    case 0:
                        unit_select=3;
                        next_unit_select=1;
                        break;
                    case 1:
                        unit_select=3;
                        next_unit_select=0;
                        break;
                    case 2:
                        unit_select=3;
                        next_unit_select=2;
                        break;
                }
                break;
                //-----KELVIN----//
            case 2:
                while(1) {
                    lcd.clear();
                    lcd.printString("Current",25,0);
                    lcd.printString("Temperature:",10,1);
                    float T = tmp102.get_temperature();
                    char Temp3 [20];
                    sprintf(Temp3,"T = %3.2f K",T+273.15);
                    lcd.printString (Temp3,2,4);
                    wait(0.1);
                    lcd.refresh();
                    if(joystick.direction==UP) {
                        selector=1;
                        break;
                    } else if(joystick.direction==DOWN) {
                        selector=2;
                        break;
                    } else {
                        selector=0;
                        break;
                    }
                }
                switch(selector) {
                    case 0:
                        unit_select=3;
                        next_unit_select=2;
                        break;
                    case 1:
                        unit_select=3;
                        next_unit_select=1;
                        break;
                    case 2:
                        unit_select=3;
                        next_unit_select=0;
                        break;
                }
                break;
                // Case to check that there is only a single transition between states per trigger of the joystick
            case 3:
                if(joystick.direction==CENTRE) {
                    unit_select=next_unit_select;
                } else {
                    unit_select=3;
                }
                break;
            default:
                error();  //invalid state - call error routine
                break;
        }
        //wait(0.05);
        sleep();
        if (Jbutton==1) {
            SwitchMenu();
        }
    }
}



void timer_isr()
{
    g_timer_flag = 1;   // set flag in ISR
}

void init_K64F()
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    re_led = 1;
    g_led = 1;
    b_led = 1;

    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);

}


void init_serial()
{
    // set to highest baud - ensure terminal software matches
    pc.baud(115200);
}


