/**
@file SnakeFunctions.h
@brief header file for snake functions
*/
#ifndef SNAKEFUNCTIONS_H

#include "mbed.h"
#include "N5110.h"

/**
@brief This library has been created to allow for snake movement
@author Ihsian Mulla
@date April 2016
*/



class SnakeFunctions
{
public:
    /** contains the rule set for snake stating global variables and functions for play
    */
    void Snake();
    /**Allows for the pause of the game during snake play
    */
    void Pause();
    /**Function to read array of highscores from sd card
    */
    void Read();
    /**Function to check score against the array of highscores and replace
    *and shift where necessary
    */
    void Check();
    /**Function to write array to SD card
    */
    void Write();
    /**Set 4 pixels for food
    */
    void SetFood();
    /**Clear 4 pixels for food
    */
    void ClearFood();
    /**Allows the serial print of the Highscore array for testing
    */
    void PrintCheck();
    /**Sets ISR to change flag
    */
    void PauseSleep_isr();
    /**Allows return to menu from game [prevents having to use NVIC_SystemReset
    */
    void SwitchMenu();

};

#endif

