//---------------------------- IHSIAN MULLA  -------------------------------------------//
//---------------------------- PRESENTS..... ------------------------------------------//
// ------------ THE ISHTENDO ORIGINAL GAMING SYSTEM ----------------------------------//


//----------------LIBRARIES-----------//////
#include "N5110.h"
#include "joystick.h"
#include "mbed.h"
#include "TMP102.h"
#include "beep.h"
#include <stdio.h>
#include <stdlib.h>

// Buzzer connceted to PWM pin
Beep buzzer(PTC10);

//On-board RGB led (only need one)
DigitalOut r_led(LED_RED);

// connections for joystick
AnalogIn xPot(PTB3);
AnalogIn yPot(PTB2);
DigitalIn Jbutton(PTB11);
InterruptIn button(PTB18);// Connection for external button

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

// Ticker functions for joystick and menu
Ticker MenuRefresh;
Ticker pollJoystick;

Joystick joystick;

// ---- Global Variables---//
int nextmenu=0; /*!< initialises chekc statement for single transition */
int menu = 0; /*!< initialises menu switch statement */
int pointer = 0; /*!< initialises pointer switch statement */

volatile int g_button_flag = 0; // sets flag in the ISR
volatile int g_MenuRefresh_flag=0; // sets the flag in the ISR

//--Functions--//
void error();
void Snake();
void Draw();
void Temp();
void Intro();
void MenuOptions();
void SwitchMenu();
void MenuRefresh_isr();
void button_isr();


//--------------------  MAIN  ------------------------------------------//

int main()
{
    lcd.init(); // intialise LCD
    lcd.setBrightness(0.5);
    lcd.normalMode();
    Intro();
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,0.25);  // read joystick 10 times per second
    SwitchMenu();
}

void Intro()
{
    lcd.printString("ishtendo",10,2);
    lcd.printString("vI",70,5);
    lcd.printString(".",45,3);
    buzzer.beep(1000,0.5);
    wait(1.0);
    lcd.printString(".",55,3);
    buzzer.beep(1000,0.5);
    wait(1.0);
    lcd.printString(".",65,3);
    buzzer.beep(1000,0.5);
    wait(1.0);
    buzzer.beep(1500,0.5);
    lcd.clear();
    lcd.refresh();
}

void MenuOptions()
{
    lcd.printString("Snake",30,0.5);
    lcd.printString("Draw",33,2.5);
    lcd.printString("Temp Sensor",5,4.5);
}

//switch statement to allow for selection and option highlight user interface
void SwitchMenu()
{
    button.fall(&button_isr);
    button.mode(PullDown);
    MenuRefresh.attach(&MenuRefresh_isr,0.5); //attach ticker to prevent the board sleeping and becoming unresponsive

    while(1) {
        switch (menu) {
            case 0: // Snake Selection
                lcd.clear();
                MenuOptions();
                lcd.printString("<",75,0.5);//
                // check if flag i.e. interrupt has occured
                if (g_button_flag) {
                    g_button_flag = 0;  // if it has, clear the flag
                    Snake();
                }
                if(joystick.direction==DOWN)
                    pointer=1;
                else if(joystick.direction==UP)
                    pointer=2;
                else
                    pointer=0;
                //implements a switch statement within a switch statement to allow user interface from a joystick
                //to transition between the 3 states to highlight and select a game option
                switch(pointer) {
                    case 0:
                        menu=3;
                        nextmenu=0;
                        break;
                    case 1:
                        menu=3;
                        nextmenu=2;
                        break;
                    case 2:
                        menu=3;
                        nextmenu=1;
                        break;
                }
                break;
            case 1 : // Draw Selection
                lcd.clear();
                MenuOptions();
                lcd.printString("<",75,2.5);
                // check if flag i.e. interrupt has occured
                if (g_button_flag) {
                    g_button_flag = 0;  // if it has, clear the flag
                    Draw();
                }
                if(joystick.direction==DOWN)
                    pointer=1;
                else if(joystick.direction==UP)
                    pointer=2;
                else
                    pointer=0;
                switch(pointer) {
                    case 0:
                        menu=3;
                        nextmenu=1;
                        break;
                    case 1:
                        menu=3;
                        nextmenu=0;
                        break;
                    case 2:
                        menu=3;
                        nextmenu=2;
                        break;
                }
                break;
            case 2 : //Temperature Sensor Selection
                lcd.clear();
                MenuOptions();
                lcd.printString("<",75,4.5);
                // check if flag i.e. interrupt has occured
                if (g_button_flag) {
                    g_button_flag = 0;  // if it has, clear the flag
                    Temp();
                }
                if(joystick.direction==DOWN) {
                    pointer=1;

                } else if (joystick.direction==UP) {
                    pointer=2;

                } else {
                    pointer=0;
                }
                switch(pointer) {
                    case 0:
                        menu=3;
                        nextmenu=2;
                        break;
                    case 1:
                        menu=3;
                        nextmenu=1;
                        break;
                    case 2:
                        menu=3;
                        nextmenu=0;
                        break;
                }
                break;
            case 3: //Checks to prevent multiple transitions of menu cursor (one transition per joystick movement)
                if(joystick.direction==CENTRE) {
                    menu=nextmenu;
                } else {
                    menu=3;
                }
                break;
            default:
                error();  //invalid state - call error routine
                // or could jump to starting state i.e. state = 0
                break;
        }
        sleep();
    }
}

//  event-triggered interrupt
void button_isr()
{
    g_button_flag = 1;   // set flag in ISR

}
//Timer isr
void MenuRefresh_isr()
{
    g_MenuRefresh_flag =1;
}

//  error message -  flashing red led
void error()
{
    while(1) {
        r_led = 0;
        wait(0.2);
        r_led = 1;
        wait(0.2);
    }
}
