/** Snake Game Functions
*Implementing functions for the control and user interface with the snake
@file SnakeFunctions.cpp
@brief contains functions for pause, death and food
@author Ihsian Mulla
@date April2016
*/
//---Libraries---//
#include "mbed.h"
#include "N5110.h"
#include "beep.h"
#include "joystick.h"
#include "SDFileSystem.h"
#define DIRECTION_TOLERANCE 0.25L

extern Joystick joystick;
extern N5110 lcd;
extern Beep buzzer;

// Connections to SD card holder on K64F (SPI interface)
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS

Serial serial(USBTX, USBRX);  // for PC debug


int Direction = 3; /*!<1-UP 2-DOWN 3-RIGHT 4-LEFT*/
int Snake_array[150][150]; /*!<Snake postion array*/
int num = 150; /*!<max snake size*/
int snake_length =3; /*!<initial snake length*/
int Highscore[3];/*!<sets initial array of 3 integers*/
int Score = 0; /*!< initial score*/
int Fx = 60; /*!< initial food x*/
int Fy = 20; /*!< intial food y*/

volatile int g_PauseSleep_flag=0; //set flag for timer isr

//---FUNCTIONS--//
void Snake();
void Pause();
void Read();
void Write();
void Check();
void SetFood();
void ClearFood();
void PrintCheck();
void SwitchMenu();
void PauseSleep_isr();

Ticker PauseSleep;

void Snake()
{
    lcd.clear();
    serial.baud(115200);  // full-speed! set baud rate for SD card
    lcd.init(); // initialise display
    int Sx, Sy; //Snake x & Snake y
    Sx = 43; //Snake initial position x
    Sy = 23; //snake intial position y
    SetFood();//Sets food position

    while(1) {
        //shifts array down for x &y
        for(int i =num-1; i>0; i--) {
            Snake_array[0][i]=Snake_array[0][i-1];
            Snake_array[1][i]=Snake_array[1][i-1];
        }

        Snake_array[0][0]=Sx;//sets the head of snake as first x value in the array
        Snake_array[1][0]=Sy;//sets the head of snake as first y value in the array
        lcd.setPixel(Snake_array[0][1],Snake_array[1][1]);       //set pixels 1st pixel based on x,y value from the array
        lcd.clearPixel(Snake_array[0][snake_length+1],Snake_array[1][snake_length+1]); //clears pixel behind snake
        Snake_array[0][snake_length+1]=0;//allows snake to increment in length whilst adding its value to the array to the array
        Snake_array[0][snake_length+1]=0;
        lcd.refresh();
        lcd.setPixel(Sx,Sy); // set snake head position
        lcd.refresh();
        wait(0.025);
// statement to increment score and snake length when the x & y coordinates of the snakes head match those of the food
        if ((Sx == Fx && Sy==Fy)||(Sx == Fx+1 && Sy==Fy)||(Sx == Fx && Sy==Fy-1)||(Sx == Fx+1 && Sy==Fy-1)) {
            Score++; // increment score by 1 each time food is consumed
            ClearFood();
            buzzer.beep(1000,0.5);//buzzer.beep(frequency.time)
            Fx = rand() %80; //randomises food position for the x-axis
            Fy = rand() %44; //randomises food position for the y-axis
            SetFood();
            snake_length++; // increment snake length by one pixel
            lcd.refresh();
        }
        // If statement to allow snake direction to maintain previous direction if joystick is at the centre
        if (joystick.direction == CENTRE) {
            if (Direction == 1) {
                Sy++;
            }
            if (Direction == 2) {
                Sy--;
            }
            if (Direction == 3) {
                Sx++;
            }
            if (Direction == 4) {
                Sx--;
            }
        }
        // If statements to control direction of movement with joystick interface
        if (joystick.direction == UP) {
            Direction = 1;
            if (Direction == 1) {
                Sy++;
            }
        }
        if (joystick.direction == DOWN) {
            Direction = 2;
            if (Direction == 2) {
                Sy--;
            }
        }
        if (joystick.direction == LEFT) {
            Direction = 3;
            if (Direction == 3) {
                Sx++;
            }
        }
        if (joystick.direction == RIGHT) {
            Direction = 4;
            if (Direction == 4) {
                Sx--;
            }
        }
        if (Jbutton==1) {
            Pause();
        }
        //Game Over - if snake head coordinates equal the coordinates of any pixels in the snake array
        // or the coordinates of the hard boundary or itself
        for (int i=0; i<=200; i++) {
            if (((Snake_array[0][i]==Sx)&&(Snake_array[1][i]==Sy))||(Sx>=82)||(Sx <= 0)||(Sy >= 46)||(Sy <= 0)) {
                buzzer.beep(1500,0.5); //buzzer.beep(frequency(Hz),time(seconds));
                wait(0.5);
                buzzer.beep(500,0.5);
                lcd.clear();
                lcd.printString("GAME OVER",10,1);
                lcd.printString("SCORE:",2,3);
                char buffer[14];
                sprintf(buffer,"%d",(Score*10));      //serial print score to buffer
                lcd.printString(buffer,50,3);    //print score to LCD
                wait(1);
                Read();
                Read();
                Check();
                Write();
                Read();
                lcd.clear();
                lcd.printString("HighScores",10,0);
                lcd.drawLine(10,11,68,11,1);
                lcd.printString("1.",20,2);
                lcd.printString("2.",20,3);
                lcd.printString("3.",20,4);
                char scre[80];
                for(int i = 0; i < 3; i++) {
                    sprintf(scre, "%i",Highscore[i]);
                    lcd.printString(scre,35,i+2);
                }
                wait(5);
                lcd.clear();
                NVIC_SystemReset();
            }
        }
        wait((0.15-(0.001*Score)));
    }
}


// ---------------Function to pause/resume the snake game------------------------//
void Pause()
{
    PauseSleep.attach(&PauseSleep_isr,5.0);
    while(1) {
        lcd.printString("Pause",25,0.5);
        lcd.drawLine(25, 9, 53, 9, 1);//underlines pause
        lcd.printString("Press Button",0,2);
        lcd.printString("to Continue",15,3);
        wait(0.1);

        if (button==1) {
            lcd.clear();
            SetFood();
            break;
        }
        sleep();
    }
}
//-------------------------------------- Advanced Reading from file -------------------------------//
void Read()
{
    FILE *fp; // this is our file pointer
    // now open file for reading...note the 'r'
    fp = fopen("/sd/HScore.txt", "r");

    int n=3;  // going to store the number of lines in the file
    int *index_array;  // pointers to create dynamic arrays later
    int *value_array; // note memory will be in heap rather than on the stack

    if (fp == NULL) {  // if it can't open the file then print error message
        // serial.printf("Error! Unable to open file!\n");
    } else {
        //serial.printf("Read %d lines\n",n);
        // calloc creates an array and initilises to 0
        // malloc returns unitialised array - diffrent syntax
        index_array = (int *)calloc(n, sizeof (int));
        value_array = (int *)calloc(n, sizeof (int));

        int i=0;
        rewind(fp); // 'scrolled' to end of file, so go back to beginning
        while (fscanf(fp,"%i,%i",&index_array[i],&value_array[i]) && (i<3)) {
            i++;  // read data into array and increment index
        }
        // we should now have the data in the arrays, will print to serial to check
        for(int i=0; i<n ; i++) {
            // serial.printf("[%d] %i,%i\n",i,index_array[i],value_array[i]);
            Highscore[i]=value_array[i];
        }
    }
    // serial.printf("End\n");
}

//--------------------- Writing list to file  -----------------------------//
void Write()
{
    FILE *fp; // this is our file pointer
    fp = fopen("/sd/HScore.txt", "w");

    if (fp == NULL) {  // if it can't open the file then print error message
        // serial.printf("Error! Unable to open file!\n");
    } else {  // opened file so can write
        // serial.printf("Writing to file....");
        for(int i = 0; i <= 3; i++) {
            fprintf(fp, "%i,%i \n",i,Highscore[i]);  // print formatted string to file (CSV)
        }
        //  serial.printf("Done.\n");
        fclose(fp);  // ensure you close the file after writing
    }
}
//--------------compares the score to the previous highscores replacing and shifting where necessary---------//
void Check()
{
    if((Score*10)>=Highscore[0]) {
        Highscore[2]=Highscore[1];
        Highscore[1]=Highscore[0];
        Highscore[0]=(Score*10);
    } else if ((Score)>=Highscore[1]) {
        Highscore[2]=Highscore[1];
        Highscore[1]=(Score*10);
    } else if ((Score)>=Highscore[2]) {
        Highscore[2]=(Score*10);
    }

    //PrintCheck();

}

void PrintCheck()
{
    serial.printf("%d\n",Highscore[0]);
    serial.printf("%d\n",Highscore[1]);
    serial.printf("%d\n",Highscore[2]);
}

void SetFood()
{
    lcd.setPixel(Fx,Fy);
    lcd.setPixel(Fx+1,Fy);
    lcd.setPixel(Fx,Fy-1);
    lcd.setPixel(Fx+1,Fy-1);
}

void ClearFood()
{
    lcd.clearPixel(Fx,Fy);
    lcd.clearPixel(Fx+1,Fy);
    lcd.clearPixel(Fx,Fy-1);
    lcd.clearPixel(Fx+1,Fy-1);
}

void PauseSleep_isr()
{
    g_PauseSleep_flag=1;
}
