/** Draw Game Functions
@brief Used for allowing Etch-a-Sketch Function with user interface
@file DrawFunctions.cpp
@author Ihsian Mulla
@date April 2016
*/

#include "mbed.h"
#include "beep.h"
#include "N5110.h"
#include "joystick.h"
#include "FXOS8700Q.h"

#define DIRECTION_TOLERANCE 0.25L

extern N5110 lcd;
extern Joystick joystick;
extern Beep buzzer;

// SDA SCL ADDRESS
FXOS8700Q_acc acc(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);
FXOS8700Q_mag mag(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1);

//Serial Pc(USBTX, USBRX);

MotionSensorDataUnits acc_data;
MotionSensorDataCounts acc_raw;


// --------------------GLOBAL VARIABLES ----------------------------------//
int flag = 0; /*!< sets flag to ensure a one decrement for one press up*/
/**
*Limits number of press-up to completion
@param a - Number of Press-ups
*/
int a = 11; /*!< a = Number of Push-Ups to complete game*/

// -- FUNCTION PROTOTYPES -- //
void Draw();
void MiniGame();
void MiniGameIntro();
void SwitchMenu();


void Draw()
{

    lcd.init(); // initialises the display
    lcd.clear(); // clears display
    calibrateJoystick();  // get centred values of joystick
    //initialise starting pixel position (x,y)
    int pixel_x, pixel_y;
    pixel_x = 40;
    pixel_y = 20;



    while(1) {
        lcd.setPixel(pixel_x,pixel_y);// set Pixel (x,y)
        lcd.refresh();
        // prevents lines being drawn whilst the button is pressed
        if(button==1) {
            lcd.clearPixel(pixel_x,pixel_y);
        }
        // allows joystick movement to be reciprocated in drawing direction by adding or subtracting x & y values
        if (joystick.direction == DOWN) {
            if (pixel_y <= 0) pixel_y = 0;
            else pixel_y = pixel_y - 1;
        }
        if (joystick.direction == UP) {
            if (pixel_y >= 48) pixel_y = 48;
            else pixel_y = pixel_y + 1;
        }
        if (joystick.direction == RIGHT) {
            if (pixel_x <= 0) pixel_x = 0;
            else pixel_x = pixel_x - 1;
        }
        if (joystick.direction == LEFT) {
            if (pixel_x >= 84) pixel_x = 84;
            else pixel_x = pixel_x + 1;
        }
        if ((pixel_x>74) &&(pixel_y>38)) {
            MiniGameIntro();
        }
        if (Jbutton==1) {
            SwitchMenu();
        }
        wait(0.05);
    }
}


void MiniGame()
{
    lcd.init(); // initialise LCD
    acc.enable(); // enable the FXOS8700Q accelerometer

    while(1) {
        lcd.clear(); // clear lcd
        acc.getAxis(acc_data); // get x,y,z values
        // Pc.printf("X=%4.1f Y=%4.1f Z=%4.1f\r\n", acc_data.x, acc_data.y, acc_data.z);
        int Ballx = 44+(-43*acc_data.x); // optimise x values to remain within lcd boundary
        int Bally = 24+(-23*acc_data.y); // optimise y values to remain within lcd boundary
        lcd.drawCircle(Ballx,Bally,3,0); // draw ball at cnetre (x,y)
        // Draws arms on the Push-up man
        lcd.drawLine(Ballx+1, Bally, 69, 30, 1);
        lcd.drawLine(Ballx-1, Bally, 20, 30, 1);
        lcd.drawLine(69, 30, 69, 40, 1);
        lcd.drawLine(20, 30, 20, 40, 1);
        lcd.printString("Push",5,1);
        lcd.printString("Up",10,2);

        if((acc_data.y<0.4)&& (flag==0)) {
            flag=1; // flag to ensure one push - up = one decrement of 'a'
            buzzer.beep(1000,0.15); // beep after each push-up
            a--;
        }
        if(acc_data.y>0.5) {
            flag=0; // reset flag
        }
        char pressups [20];
        sprintf(pressups,"%i",a);
        lcd.printString(pressups,65,1);
// When 10 push ups complete (a=0) = completion --> back to menu
        if(a==0) {
            while(1) {
                lcd.clear();
                lcd.printString("Congrats",10,1);
                lcd.printString("You Have",10,2);
                lcd.printString("Completed The",2,3);
                lcd.printString("Mini Game",10,4);
                buzzer.beep(1000,0.5);
                buzzer.beep(1100,0.5);
                buzzer.beep(1200,0.5);
                buzzer.beep(1300,0.5);
                buzzer.beep(1400,0.5);
                buzzer.beep(1500,0.5);
                buzzer.beep(1600,0.5);
                buzzer.beep(1700,0.5);
                buzzer.beep(1800,0.5);
                buzzer.beep(1900,0.5);
                buzzer.beep(2000,0.5);
                wait(5);
                SwitchMenu();
            }
        }
        sleep();
    }
}


void MiniGameIntro()
{
    lcd.clear();
    lcd.printString("You Have",15,1);
    lcd.printString("Unlocked The",5,2);
    lcd.printString("Hidden Game",10,3);
    wait(2);
    lcd.clear();
    lcd.printString("The",30,1.5);
    lcd.printString("Push - Up",15,2.5);
    lcd.printString("Challenge",15,3.5);
    wait(2);
    lcd.clear();
    lcd.printString("Please Fasten",5,1);
    lcd.printString("The Game to",5,2);
    lcd.printString("your arm",15,3);
    wait(3);
    lcd.clear();
    lcd.printString("Press External",1,1);
    lcd.printString("Button When", 10, 2);
    lcd.printString("Ready",25,3);
    while(1) {
        if (button==1) {
            MiniGame();
        }
    }

}
