/**
@file gameCharacters.h
@brief Revision 1.0.
@author Robin Milward Cooney
@date   May 2015
*/

//Library referencing all the arrays needed in the game


const int g_recks_still_gun[10][10]= {  
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,0,1,0,1,1,0,0},
    {0,0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0}
};  /*!<Global array for the main charachter (recks) when he is still*/

const int g_recks_moving_gun[10][10]= {      
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,0,1,0,1,1,0,0},
    {0,0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,1,0,1,0,0,0,0},
    {0,0,1,0,0,0,1,0,0,0},
    {0,1,0,0,0,0,0,1,0,0}
};      /*!<Global array for the main charachter (recks) when he is moving*/

const int g_recks_crouch_gun[10][10]= {  
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,0,1,0,1,1,0,0},
    {0,0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0}
};      /*!<Global array for the main charachter (recks) when he is crouching*/

const int g_recks_jump_gun[10][10]= {   
    {0,0,1,1,1,0,0,0,0,0},
    {0,0,1,1,1,0,0,0,0,0},
    {0,0,1,1,1,0,0,0,0,0},
    {0,0,0,1,0,1,1,0,0,0},
    {0,0,0,1,1,1,0,0,0,0},
    {0,0,0,1,0,0,1,0,0,0},
    {0,0,0,1,0,1,0,1,0,0},
    {0,0,0,0,1,0,0,0,1,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0}
};      /*!<Global array for the main charachter (recks) when he is in the jumping position*/

const int g_recks_shield[15][15]= {
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,1,0,0,0,0,0,0,0,1,0,0,0},
    {0,0,1,0,0,0,0,0,0,0,0,0,1,0,0},
    {0,1,0,0,1,0,0,0,0,0,0,0,0,1,0},
    {1,0,0,1,0,0,1,1,1,0,0,0,0,0,1},
    {1,0,0,0,0,0,1,1,1,0,0,0,0,0,1},
    {1,0,0,0,1,0,1,1,1,0,1,0,0,0,1},
    {1,0,0,0,0,1,0,1,0,1,0,0,0,0,1},
    {1,0,0,0,0,0,1,1,1,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,1,0,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,1,0,0,0,0,0,0,1},
    {0,1,0,0,0,0,1,0,1,0,0,0,0,1,0},
    {0,0,1,0,0,1,0,0,0,1,0,0,1,0,0},
    {0,0,0,1,1,0,0,0,0,0,1,1,0,0,0},
    {0,0,0,1,0,0,0,0,0,0,0,1,0,0,0}
};

const int g_mob_rat_p1[3][8]= {           
    {0,0,0,0,0,0,0,1},
    {0,1,1,1,0,0,1,0},
    {1,1,1,1,1,1,0,0}
};  /*!<Global array for a rat (position 1)*/

const int g_mob_rat_p2[3][8]= {          
    {0,0,0,0,0,0,1,0},
    {0,1,1,1,0,0,1,0},
    {1,1,1,1,1,1,0,0}
};      /*!<Global array for a rat (position 2)*/

const int g_mob_hound_p1[8][13]= {        
    {0,0,0,1,0,0,0,0,0,0,0,0,0},
    {0,1,1,1,0,0,0,0,0,0,0,1,0},
    {1,1,1,1,0,0,0,0,0,0,0,1,0},
    {1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,0,0,0,0,0,0,1,0,0},
    {0,0,0,1,0,0,0,0,0,0,1,0,0},
    {0,0,0,1,0,0,0,0,0,0,1,0,0}
};  /*!<Global array for a still hound*/

const int g_mob_hound_p2[8][13]= {       
    {0,0,0,1,0,0,0,0,0,0,0,0,0},
    {0,1,1,1,0,0,0,0,0,0,0,0,1},
    {1,1,1,1,0,0,0,0,0,0,0,1,0},
    {1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,0,0},
    {0,0,1,0,0,0,0,0,0,0,0,1,0},
    {0,1,0,0,0,0,0,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,0,0,0,0,0,1}
};      /*!<Global array for a moving hound*/

const int g_mob_hound_dead[8][13]= {        
    {0,0,0,0,0,0,0,0,0,0,1,0,1},
    {0,0,1,0,0,1,0,1,0,1,0,0,1},
    {0,1,0,1,0,0,0,0,0,0,0,1,0},
    {0,0,0,0,1,1,0,1,0,1,0,0,0},
    {0,0,0,0,1,0,1,0,0,1,0,0,0},
    {0,0,0,0,0,1,0,0,0,0,0,0,0},
    {0,1,0,0,0,0,1,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0,0,0,0}
};      /*!<Global array for a destroyed hound*/

const int g_mob_bear_p1[10][19]= {      
    {0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0},
    {0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0},
    {0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0}
};  /*!<Global array for a still bear*/

const int g_mob_bear_p2[10][19]= {  
    {0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0},
    {0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0},
    {1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1}
};  /*!<Global array for a moveing bear*/

const int g_mob_bear_dead[10][19]= {      
    {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
    {0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,0,1,0},
    {0,0,0,1,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0},
    {0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0},
    {0,0,0,1,1,0,1,0,0,0,1,1,0,0,0,0,1,0,0},
    {0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,1,1,0,0},
    {0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};  /*!<Global array for a destroyed bear*/


const int g_mob_bird_p1 [10][10]= {
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,1,0,0,0,0},
    {0,0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,0,0,0},
    {0,1,1,0,1,1,1,0,0,0},
    {1,1,1,1,1,1,1,1,1,1},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0}
};  /*!<Global array for a bird (position 1)*/

const int g_mob_bird_p2 [10][10]= {
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,1,1,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1},
    {0,0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,1,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0}
};  /*!<Global array for a bird (position 2)*/

const int g_mob_bird_dead [10][10]= {
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0,0},
    {0,0,0,0,1,0,1,0,1,0},
    {0,1,0,0,0,0,0,0,0,0},
    {1,0,0,0,1,1,1,1,1,0},
    {0,0,1,0,0,0,0,0,0,0},
    {0,1,0,0,0,1,0,1,0,0},
    {0,0,0,1,0,0,0,0,0,1},
    {0,0,0,0,0,0,0,0,0,0}
};  /*!<Global array for a destroyed bird*/

const int g_cactus[12][5]= {
    {0,0,1,0,0},
    {0,0,1,0,0},
    {0,0,1,0,1},
    {1,0,1,0,1},
    {1,0,1,0,1},
    {1,0,1,0,1},
    {1,1,1,1,1},
    {0,0,1,0,0},
    {0,0,1,0,0},
    {0,0,1,0,0},
    {0,0,1,0,0},
    {0,0,1,0,0}
};      /*!<Global array for a cactus*/

const int g_t_rex[28][25]= {
    {0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0}
};      /*!<Global array for a still T Rex*/

const int g_t_rex_moving[28][25]= {
    {0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0},
    {0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0}
};           /*!<Global array for a moving T Rex*/

const int g_t_rex_attack[28][25]= {
    {0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},
    {1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1},
    {0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0},
    {0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0}
};       /*!<Global array for an attacking T Rex*/

const int g_fire_ball_p1[9][9]= {
    {0,0,0,1,0,1,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,1,0,0,1,0,0,1,0},
    {0,0,0,1,1,1,0,0,0},
    {1,0,1,1,1,1,1,0,1},
    {0,0,0,1,1,1,0,0,0},
    {0,1,0,0,1,0,0,1,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,1,0,1,0,0,0}
};      /*!<Global array for a fire ball (position 1)*/

const int g_fire_ball_p2[9][9]= {
    {0,0,0,0,1,0,0,0,0},
    {0,0,1,0,0,0,1,0,0},
    {0,0,0,0,1,0,0,0,0},
    {1,0,0,1,1,1,0,0,1},
    {0,0,1,1,1,1,1,0,0},
    {1,0,0,1,1,1,0,0,1},
    {0,0,0,0,1,0,0,0,0},
    {0,0,1,0,0,0,1,0,0},
    {0,0,0,0,1,0,0,0,0}
};          /*!<Global array for a fire ball (position 2)*/

const int g_clouds[3][342]= {
    {0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, 0,0,1,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,0,1,1,1,1,0,0,0,0, 0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0, 0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0, 0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1, 0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0, 0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0},
    {0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0, 1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1,0,1,1,1,1,0,0, 0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,0,0,1, 1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0}
};          /*!<Global array for clouds, they loop round when it reaches the end*/

const int g_score[5][19]= {
    {1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1},
    {1,0,0,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,0},
    {1,1,1,0,1,0,0,0,1,0,1,0,1,1,0,0,1,1,0},
    {0,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,0},
    {1,1,1,0,1,1,1,0,1,1,1,0,1,0,1,0,1,1,1}
};  /*!<Global array for the word "SCORE" in a smaller font than the deffault 6x6*/

const int g_ammo[5][15]= {
    {1,1,1,0,1,0,1,0,1,0,1,0,1,1,1},
    {1,0,1,0,1,1,1,0,1,1,1,0,1,0,1},
    {1,1,1,0,1,0,1,0,1,0,1,0,1,0,1},
    {1,0,1,0,1,0,1,0,1,0,1,0,1,0,1},
    {1,0,1,0,1,0,1,0,1,0,1,0,1,1,1}
};  /*!<Global array for the word "AMMO" in a smaller font than the deffault 6x6*/

const int g_speed_boost[7][14]= {
    {1,0,0,0,0,1,0,0,0,0,1,0,0,0},
    {0,1,0,0,0,0,1,0,0,0,0,1,0,0},
    {0,0,1,0,0,0,0,1,0,0,0,0,1,0},
    {0,0,0,1,0,0,0,0,1,0,0,0,0,1},
    {0,0,1,0,0,0,0,1,0,0,0,0,1,0},
    {0,1,0,0,0,0,1,0,0,0,0,1,0,0},
    {1,0,0,0,0,1,0,0,0,0,1,0,0,0}
};  /*!<Global array for the speed boost pickup*/

const int g_heart[5][5]= {
    {0,1,0,1,0},
    {1,1,1,1,1},
    {1,1,1,1,1},
    {0,1,1,1,0},
    {0,0,1,0,0}
};    /*!<Global array for the heart pickup*/

const int g_ammo_pickUp[8][7]= {
    {1,1,1,1,1,1,1},
    {1,0,0,0,0,0,1},
    {1,0,1,1,1,0,1},
    {1,0,1,0,1,0,1},
    {1,0,1,1,1,0,1},
    {1,0,1,0,1,0,1},
    {1,0,0,0,0,0,1},
    {1,1,1,1,1,1,1}
};    /*!<Global array for the ammo pickup*/

const int g_padlock_p1[6][4]= {
    {0,1,1,0},
    {1,0,0,1},
    {1,0,0,1},
    {1,1,1,1},
    {1,1,1,1},
    {1,1,1,1}
};       /*!<Global array for a closed padlock. To use as a locked icon for story mode*/

const int g_padlock_p2[6][4]= {
    {0,1,1,0},
    {1,0,0,1},
    {1,0,0,0},
    {1,1,1,1},
    {1,1,1,1},
    {1,1,1,1}
};      /*!<Global array for a open padlock. To use as a unlocked icon for story mode*/

const int zero[5][3]= {
    {1,1,1},
    {1,0,1},
    {1,0,1},
    {1,0,1},
    {1,1,1}
};   /*!<Global array for the number 0 in a smaller font than the standard 6x6*/

const int one [5][3]= {
    {0,1,0},
    {1,1,0},
    {0,1,0},
    {0,1,0},
    {1,1,1}
};  /*!<Global array for the number 1 in a smaller font than the standard 6x6*/

const int two [5][3]= {
    {1,1,1},
    {0,0,1},
    {1,1,1},
    {1,0,0},
    {1,1,1}
};  /*!<Global array for the number 2 in a smaller font than the standard 6x6*/

const int three [5][3]= {
    {1,1,1},
    {0,0,1},
    {0,1,1},
    {0,0,1},
    {1,1,1}
};  /*!<Global array for the number 3 in a smaller font than the standard 6x6*/

const int four [5][3]= {
    {1,0,1},
    {1,0,1},
    {1,1,1},
    {0,0,1},
    {0,0,1}
};  /*!<Global array for the number 4 in a smaller font than the standard 6x6*/

const int five [5][3]= {
    {1,1,1},
    {1,0,0},
    {1,1,1},
    {0,0,1},
    {1,1,1}
};  /*!<Global array for the number 5 in a smaller font than the standard 6x6*/

const int six [5][3]= {
    {1,1,1},
    {1,0,0},
    {1,1,1},
    {1,0,1},
    {1,1,1}
};  /*!<Global array for the number 6 in a smaller font than the standard 6x6*/

const int seven [5][3]= {
    {1,1,1},
    {0,0,1},
    {0,0,1},
    {0,0,1},
    {0,0,1}
};/*!<Global array for the number 7 in a smaller font than the standard 6x6*/

const int eight [5][3]= {
    {1,1,1},
    {1,0,1},
    {1,1,1},
    {1,0,1},
    {1,1,1}
};  /*!<Global array for the number 8 in a smaller font than the standard 6x6*/

const int nine [5][3]= {
    {1,1,1},
    {1,0,1},
    {1,1,1},
    {0,0,1},
    {0,0,1}
};  /*!<Global array for the number 9 in a smaller font than the standard 6x6*/

const float song1[]= {
    0.108,
    880,0,0,0,0,0,0,0,0,0,880,0,880,0,1568,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    698,0,0,0,0,0,0,0,0,0,698,0,698,0,1568,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,1568,0,
    880,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    880,0,0,0,0,0,0,0,988,0,0,0,
    1047,0,0,0,1047,0,0,0,988,0,880,0,0,0,0,0,
    880,0,0,0,1568,0,0,0,0,0,880,0,0,0,
    880,0,1568,0,0,0,0,0,1047,0,0,0,988,0,0,0,
    880,0,0,0,0,0,0,0,988,0,0,0,
    1047,0,0,0,1047,0,0,0,988,0,1047,0,0,0,0,0,
    1319,0,0,0,1175,0,0,0,0,0,1319,0,0,0,
    1319,0,1175,0,0,0,0,0,1319,0,1175,0,1319,0,1175,0,
    880,0,0,0,0,0,0,0,1047,0,1319,0,
    0,0,1760,0,0,0,2093,0,0,0,1976,0,0,0,1568,0,
    1568,0,0,0,0,0,0,0,0,0,0,0,1760,0,1976,0,
    0,0,2093,0,0,0,1760,0,0,0,2093,0,1568,0,0,0,
    698,0,0,0,0,0,0,0,1568,0,1760,0,
    0,0,1760,0,0,0,1760,0,2093,0,1976,0,0,0,0,0,
    1319,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    1319,1319,0,1319,0,1319,1175,1047,988,1319,0,0,0,0,0,0
};  /*!<Global 1D array representing the notes in the song that is played during the game
    the first element of the array is the quater beats per second all the other elements
    represent the frequancies of the notes needed for the song*/










