/**
@file fsmSnakemain.h
@file Header file containing functions prototypes,defines and gloabal variables. 
@Author  Dean Griffin
@date April 2016
*/

#ifndef FSMSNAKE_H
#define FSMSNAKE_H

#include "mbed.h"
#include "N5110.h"

// change this to alter tolerance of joystick direction
#define DIRECTION_TOLERANCE 0.05f

/**
@namespace lcd
@brief lcd object
*/
//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3); // connections for screen

/**
@namespace pc (USBTX USBRX);
@brief serial for devu
*/

/**
@namespace button
@brief Digital in for joystick button
*/
DigitalIn button(PTB11); 
/**
@namespace xpot
@brief analog in for joystick x co-ordinate
*/
AnalogIn xPot(PTB2);
/**
@namespace ypot
@brief analog in for joystick y co-ordinate
*/
AnalogIn yPot(PTB3); 
/**
@namespace greenLED
@brief digital out for green game playing LED
*/
DigitalOut greenLED (PTD1); 
/**
@namespace redLED
@brief digital out for red gameover LED
*/
DigitalOut redLED(PTD0); 
/**
@namespace g_button_flag 
@brief set flag in ISR
*/
volatile int g_button_flag = 0;
/**
@namespace g_timer_flag 
@brief set flag in ISR
*/
volatile int g_timer_flag = 0;
/**
@namespace menu_isr
@brief update menu flag when called
*/
void menu_isr();
/**
@namespace button_isr
@brief update button flag when called
*/
void button_isr();


// set-up the on-board LEDs and switches
void init_K64F();

// set-up the on-board LEDs and switches
void init_K64F();



Ticker pollJoystick, checkJoystick, menuTicker, moveSnake, gameTime;
/** 
flag for joystick ticker
*/
volatile int g_joystickTimer_flag = 0;
/** 
flag for gametime ticker
*/
volatile int g_gameTimer_flag = 0;

/**brief serial out for debugging
*/

/**
@namespace pc
@brief serial connection for mbed to pc
*/
Serial pc(USBTX,USBRX);

/**
@namespace Directionname
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

/**
@namespace snakeDirection
*/
enum snakeDirection {
    up,
    down,
    left,
    right,
};

/**
@namespace joystick
@brief creates strcut for joystick
*/
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
Joystick joystick;

int printFlag = 0;

/** game functions
*/


/** menu function contains all of the game logic to be called in the main
*/
void menu();
/** reads joysticks x and y pots
*/ 
void calibrateJoystick();

/** lets the joystick know which way its being pressed
*/

void updateJoystick();

/** joystick lets snake know which way to go
*/

void checkDirection();

/** initialises game settings
*/ 
void gameSetup();


/** determines the snakes direction of travel
*/
void nextMoveSnake();

/** displays snake in next position
*/ 

void printFood();

/** check if the snake has ate the food, then produced next snack
*/
void generateFood();

/** initialises the rules for and logic for classic snake mode
*/ 
void classic ();

/** initialises the rules for and logic for classic snake two mode
*/
void snake2();

/** sets snake on game area
*/

void newSnake();

/**  called by ticker to set next screen
*/

void timer_isr();

/** called by ticker to set snake in new position
*/ 

void update_snake_isr();

/** set joystick direction to snake direction
*/

void newDirection();

/** set hardwall for classic snake mode
*/

void hardWall();

/** allows snake to go through to other other side in maze and snake 2 mode
*/

void wrapAround();

/** function to make snake tail follow its head
*/
void snakeTail();

/** lets player know its game over if the snake has died
*/

void game_over();
/**
*/

void gameTimer_ISR();

/** sets rules and logic for maze mode
*/

void maze();

/**     variable 
*/

int i;

/**     store direction of snake
*/
    
int snakeDirection;

/** array determining game areas x axis
*/  
int width [84]; 

/** array determining game areas y axis
*/
int height [48]; 

/**      snakes head on the x -axis
*/

int sx = 48; 

/** snakes head on the y-axis
*/

int sy = 24; //set snake at centre

/** food on the x-axis
*/

int fx; 

/**  food on the y-axis
*/

int fy; 

/** stores game score
*/

int score =  0;

/** stores snake length
*/

int tailL = 0;

/** array to store snake tail on x axis
*/

int tailX [100];

/** array to store snake tail on the y axis
*/

int tailY [100];

/** true when the game is running
*/
    
bool gameOver = false;

#endif