#include "mbed.h"
#include "fsmSnakemain.h"

int main()
{
    lcd.init();
    wait(2); //wait for power to settle
    lcd.refresh();
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    checkJoystick.attach(&updateJoystick,0.1);
    moveSnake.attach(&nextMoveSnake,0.3);
    gameTime.attach(&gameTimer_ISR,0.3);
    menuTicker.attach(&menu_isr,0.3); 
    //button.fall(&button_isr);
    //gameSetup();

    menu(); // run the menu (while loop is contained in here)
  
}

void menu()
{
    int y = 3; // set initial bank as 3 for the middle text

    while (1) { // while 1
        lcd.printString ("Menu",15,0); // print text
        lcd.printString ("Classic", 15,2);
        lcd.printString ("Snake 2",15,3);
        lcd.printString ("Maze",15,4);
        checkDirection();
        if (g_timer_flag) { // ticker 
            g_timer_flag = 0; // reset ticker
            lcd.clear(); // clear

            // if down, move cursor down
            if (joystick.direction == RIGHT) {
                y++; // increase bank 
                if ( y>4) { // wrap around bank (only works one way)
                    y = 2; 
                }
            }
            // if selected, run the code highlighted...
            if (button) { // interrupt occured

                if (y == 2) { // if first option
                    // run classic
                    classic();
                } else if (y == 3) { // if second option
                    // run snake 2
                    snake2();
                } else if ( y == 4) { // if third option
                    // run maze
                    maze();
                }
            }
            lcd.printChar('<',75,y); // print the char to show position 
            lcd.refresh(); // refresh screen 
        }
        sleep(); // sleep until ticker interrupt
    }
}
// SW2 event-triggered interrupt
void button_isr()
{
    g_button_flag = 1;   // set flag in ISR
}

// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}

void menu_isr()
{
    g_timer_flag = 1;
}

void checkDirection()
{
        pc.baud(115200);
        pc.printf("x = %f y = %f button = %d ",joystick.x,joystick.y,joystick.button);

        // check joystick direction
        if (joystick.direction == UP)
            pc.printf(" UP\n");
        if (joystick.direction == DOWN)
            pc.printf(" DOWN\n");
        if (joystick.direction == LEFT)
            pc.printf(" LEFT\n");
        if (joystick.direction == RIGHT)
            pc.printf(" RIGHT\n");
        if (joystick.direction == CENTRE)
            pc.printf(" CENTRE\n");
        if (joystick.direction == UNKNOWN)
            pc.printf(" Unsupported direction\n");

}


void nextMoveSnake () // function to control snake with joystick
{
    lcd.clearPixel(sx,sy);

    if (snakeDirection == up) { // if direction of joystick is up move head y axis down element of array to go up
        sy--;

    } else if  (snakeDirection == down) { //if direction of joystick is down move head y axis up element of array to go down
        sy++;

    }

    else if (snakeDirection == left) { //if direction of joystick is left move head x axis down one  element of array to go left
        sx++;

    }

    else if (snakeDirection == right) { // if direction of joystick is rigth, move head x axis up one element to go right
        sx--;

    }
}

void newDirection ()
{
    if  (joystick.direction == UP) {
        snakeDirection = up;

    } else if  (joystick.direction == DOWN) {
        snakeDirection = down;


    }

    else if (joystick.direction == LEFT) {
        snakeDirection = left;


    }

    else if (joystick.direction == RIGHT) {
        snakeDirection = right;
    } else {
        snakeDirection = snakeDirection;
    }
}


void snakeTail()
{
    int prevX = tailX[0];
    int prevY  = tailY[0];
    int prev2X, prev2Y;

    for( int i = 1; i < tailL; i++) {
        prev2X = tailX[i];
        prev2Y = tailY[i];
        tailX[i] = prevX;
        tailY[i] = prevY;
        prevX = prev2X;
        prevY = prev2Y;

        lcd.setPixel (tailX[i],tailY[i]);
    }
}


void newSnake ()
{
    lcd.setPixel (sx,sy);
    lcd.refresh();
}

void generateFood () // function to gerneate food
{

    if (sx == fx && sy == sx) {

        lcd.clearPixel(fx,fy); // remove previous food from screen
        printFood();
        score ++; // add 1 to score
        tailL ++; // length of snake increases
        lcd.refresh();
    }
}

void classic ()
{
  
    if (g_gameTimer_flag == 1) {
        g_gameTimer_flag = 0;

        while(!gameOver) {
             gameSetup();
             hardWall();
            newDirection();
            nextMoveSnake();
            newSnake();
            generateFood();

        }
        sleep();
    }

}
void snake2()
{

         
    while (!gameOver) {

        if (g_gameTimer_flag == 1) {
            g_gameTimer_flag = 0;

           


             gameSetup();
         wrapAround();
            snakeTail();
            nextMoveSnake();
            newSnake();
            generateFood();

        }
        sleep();
    }

}

void maze ()   // function to set up maze game
{
   

    while (!gameOver) {
            checkDirection();
        if (g_gameTimer_flag == 1) {
            g_gameTimer_flag = 0;
             gameSetup();
            wrapAround();
            snakeTail();



            nextMoveSnake();
            newSnake();
            generateFood();

        }
        sleep();
    }
}

void hardWall()
{
    lcd.drawRect(0,0,84,48,0);    // sets hardwall
    if ( sx > 84 || sx < 0 || sy  > 48 || sy < 0) { // if snake touches wall, snake dies
        game_over();
    }

}
void wrapAround () // function to let snake wrap around screen

{

    if (sx > 84) { // if snake goes off the right of the screen
        sx = 0; // set back to the left side
    }

    if (sx < 0) { // if snake goes off the left of the screen
        sx = 84; //set back the right of the screen
    }

    if (sy < 0) { // if snake off the top of the screen
        sy = 48; // set snake to bottom
    }

    if (sy > 48) { // if snake goes off the bottom of the screen
        sy = 0; // set back to the top of the screen
    }


}



void printFood()
{
    lcd.setPixel(fx,fy); // print food to game area
    lcd.clear(); // refresh screen

}

void gameSetup()
{
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    checkJoystick.attach(&updateJoystick,0.1);
    moveSnake.attach(&nextMoveSnake,0.3);
    lcd.init();
    lcd.clear();
    lcd.normalMode();
    lcd.setBrightness(0.5);
    lcd.setPixel(sx,sy); // set food at random
    printFood();
}

void game_over()
{
    lcd.printString("Game Over",15,2); // print game over to screen

}

void joystickTimer_isr()
{
    g_joystickTimer_flag = 1;   // set flag in ISR

}


void gameTimer_ISR()
{
    g_gameTimer_flag = 1;   // set flag in ISR
}
