#include "main.h"

///enumerator stores the 9 possible directions the joystick could be positioned in
enum DirectionName {
    Up,
    Upright,
    Right,
    Downright,
    Down,
    Downleft,
    Left,
    Upleft,
    Center,
};

typedef struct JoyStick Joystick;
struct JoyStick {
    float x;
    float x0;
    float y;
    float y0;
    int button;
    DirectionName direction;
};
Joystick joystick;
int main()
{

    lcd.init(); //the screen is initialised to allow interaction

    ticker.attach(&timer_isr,0.1);
    calibrateJoystick();
    b1.fall(&b1_isr);
    b2.fall(&b2_isr);

    b1.mode(PullDown);      //sets b1 as a pull down
    b2.mode(PullDown);      //sets b2 as a pull down

    //A Welcome message is displayed

    lcd.printString("Welcome to",2,1);
    lcd.printString("Asteroids" ,2,2);
    lcd.refresh();              //the screen is refreshed to display the message
    wait(2);                    //a small wait so the player can read the message
    lcd.clear();                //clers the message
    g_b1_flag =0;               //sets the flags to 0
    g_b2_flag = 0;
    while(1) {
        lcd.printString("Menu",1,1);
        lcd.printString("Play",2,2);
        lcd.printString("Settings",2,3);                //prints the two options on the menu
        lcd.refresh();                                  //refresh required to display on screen
        if (g_b2_flag) {
            g_b2_flag =0;                               //reset the flag
            break;                                      //breaks out the while loop and heads into the main game
        }
        if(g_b1_flag) {
            g_b1_flag = 0;                              //the flag is cleared
            settings =1;                                //settings variable is increased to 1to allow the settings menu to be accessed
            lcd.clear();
        }

        while(settings == 1) {
            lcd.printString("Normal Mode",2,2);
            lcd.printString("Inverse mode",2,3);        //prints the options from the settings menu
            lcd.refresh();

            if (g_b2_flag) {
                g_b2_flag = 0;                          //resets the flag
                lcd.normalMode();                       //normal mode is activated
                settings = 0;                           //the settings is decreased to 0 to exit the loop
                lcd.clear();                            //the screen is cleared
            }
            if (g_b1_flag) {
                g_b1_flag = 0;                          //resets the flag
                lcd.inverseMode();                      //inverse mode is activated
                settings = 0;                           //settings is decreased to 0 to exit the loop
                lcd.clear();                            //the screen is cleared
            }
        }
    }
    while(1) {
        while(game_over == 0) {     //so long as game_over is 0 the game will loop
            if (g_timer_flag) {     //the code will periodically run based on the timer
                g_timer_flag = 0;   //resets the timer flag
                updateJoystick();   // the joystick is read
                lcd.clear();        //the previous screen is cleared
                game();             //the game function
                score ++;
                //the score is incremented with time
                lcd.refresh();      //the screen is refreshed to display the updated settings
            }
            sleep();                //the mbed is put to sleep to try and save power
        }

        lcd.clear();                            //the screen is cleared
        char buffer[14];
        sprintf(buffer,"%d",score);

        lcd.printString("GAME OVER",2,2);       //the message game over is printed
        lcd.printString(buffer,3,3);            //the players score is also printed


        lcd.refresh(); // refreshes the screen for players to see they lost and their score
        wait(2);        // a small wait so players can see the score
        score = 0; //resets the score
        game_over = 0;    //reset the game over so players can play again
    }


}



/// time-triggered interrupt
void timer_isr()
{
    g_timer_flag = 1;   // set flag in ISR
}

/// button event-triggered interrupt
void b1_isr()
{
    g_b1_flag = 1;   // set flag in ISR
}

/// button evet-triggered interrupt
void b2_isr()
{
    g_b2_flag = 1;   // set flag in ISR
}

///calibrates Joystick to a default position
void calibrateJoystick()
{
    joystick.x0 = xPot;     //the current value of the x potentiometer is set as the center position
    joystick.y0 = yPot;     //the current value of the y potentiometer is set as the center position
}

///the joystick updates its position
void updateJoystick()
{
    joystick.x = xPot - joystick.x0;    //the center position of x is subtracted from the current position of the x potentiometer
    joystick.y = yPot - joystick.y0;    //the center position of y is subtracted from the current position of the y potentiometer


///based on the value calculated the joystick is given an overall direction

    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = Center;
    } else if (joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = Up;
    } else if (joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = Down;
    } else if (joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = Left;
    } else if (joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = Right;
    } else if (joystick.x < DIRECTION_TOLERANCE && joystick.y > DIRECTION_TOLERANCE) {
        joystick.direction = Upright;
    } else if (joystick.x < DIRECTION_TOLERANCE && joystick.y < DIRECTION_TOLERANCE) {
        joystick.direction = Downright;
    } else if (joystick.x > DIRECTION_TOLERANCE && joystick.y > DIRECTION_TOLERANCE) {
        joystick.direction = Upleft;
    } else if (joystick.x > DIRECTION_TOLERANCE && joystick.y < DIRECTION_TOLERANCE) {
        joystick.direction = Downleft;
    }

    printFlag = 1;
}
///the function to move and create new bullets
void shoots()
{
    /* the array shoot[4][10] is used to move and track the bullets
    the first coloumn is used to count the bullet numbers, the second coloumn determines the bullets' direction
    and the third and fourth determine the bullets' x & y position.
    */

    for(int x = 0; x<10; x++) {         //loops through each row in the array

        if(shoot[x][0]!=0) {            //checks to see if there is a bullet present in that array

            switch(shoot[x][1]) {       //selects a case based on the directionthe bullet needs to travel


                case 0:                             //shooting up
                    if (shoot[x][2] == 0) {         //start positon of bullet
                        shoot[x][2] = 24;           //starting x coordinate
                    }
                    shoot[x][2] = shoot[x][2];      //the bullet's x coordinate will remain constant
                    if (shoot[x][3] == 0) {         //start positon of bullet
                        shoot[x][3] = 21;           //starting y coordinate
                    }
                    shoot[x][3] = shoot[x][3]-1;    //the bullet's y coordinate decreases to make it move up
                    break;


                case 1:                             //shooting Up Right
                    if (shoot[x][2] == 0) {         //checks to see if bullet is in start position
                        shoot[x][2] = 27;           //starting x coordinate
                    }
                    shoot[x][2] = shoot[x][2]+1;    //the bullet's x coordinate will increase to move it right
                    if (shoot[x][3] == 0) {         //checks to see if in starting position
                        shoot[x][3] = 19;           //starting y coordinate
                    }
                    shoot[x][3] = shoot[x][3]-1;    //the bullet's y coordinate decreases to make it move up
                    break;


                case 2:                             //Shooting Right
                    if (shoot[x][2] == 0) {         //checks to see if in starting position
                        shoot[x][2] = 28;           //starting x coordinate
                    }
                    shoot[x][2] = shoot[x][2]+1;    //the bullet's x coordinate increases to move it right
                    if(shoot[x][3] == 0) {          //checks to see if in starting position
                        shoot[x][3] = 24;           //starting y coordinate
                    }
                    shoot[x][3] = shoot[x][3];      //as y coordinate doesn't change this is kept constant
                    break;


                case 3:                             //Shooting Down Right
                    if(shoot[x][2]==0) {            //checks to see if in starting position
                        shoot[x][2] = 28;           //starting x coordinate
                    }
                    shoot[x][2] = shoot [x][2]+1;   //x coordinate increases to move bullet right
                    if(shoot [x][3]==0) {           //checks to see if in starting position
                        shoot[x][3] = 27;           //starting y coordinate
                    }
                    shoot[x][3] = shoot[x][3]+1;    //y coordinate increase to move bullet down
                    break;


                case 4:                             //shoot Down
                    if (shoot[x][2]==0) {           //checks to see if in starting position
                        shoot[x][2] = 24;           //starting x coordinate
                    }
                    shoot [x][2] = shoot [x][2];    //down has no x horizontal movement so kept constant
                    if(shoot [x][3] == 0) {         //checks to see if in starting position
                        shoot[x][3]= 28;            //starting y position
                    }
                    shoot[x][3] = shoot[x][3]+1;    //y coordinate increases to move bullet down
                    break;


                case 5:                             //shoot down left
                    if (shoot[x][2]==0) {           //checks to see if in starting position
                        shoot[x][2] = 20;           //starting x coordinate
                    }
                    shoot[x][2] = shoot [x][2]-1;   //x coordinate decreases to move bullet left
                    if (shoot[x][3]==0) {           //checks to see if in starting position
                        shoot [x][3]= 27;           //starting y position
                    }
                    shoot[x][3]= shoot[x][3]+1;     //y coordinate increases to move bullet down
                    break;


                case 6:                             //shoot Left
                    if (shoot[x][2]==0) {           //checks to see if in starting position
                        shoot[x][2] = 21;           //starting x position
                    }
                    shoot[x][2] = shoot [x][2]-1;   //x coordinate decreases causing bullet to move left
                    if (shoot[x][3]==0) {           //checks to see if in starting position
                        shoot [x][3]= 24;           //starting y position
                    }
                    shoot[x][3]= shoot[x][3];       //no vertical movement so y coordinate stays constant
                    break;


                case 7:                             //shoots Up left
                    if (shoot[x][2]==0) {           //checks to see if in starting position
                        shoot[x][2] = 22;           //starting x position
                    }
                    shoot[x][2] = shoot [x][2]-1;   //x coordinates decrease to move bullet left
                    if (shoot[x][3]==0) {           //checks to see if in starting position
                        shoot [x][3]= 21;           //starting y positon
                    }
                    shoot[x][3]= shoot[x][3]-1;     //y coodrinates decrease to move bullet up
                    break;

            }

        }
    }
    for (int x=0; x<10; x++) {                          //loops through each row
        if(shoot[x][1]==0 || shoot[x][1]==4) {          //checks if the ship is facing up or down
            for(int i=0; i<1; i++) {
                for(int j=0; j<2; j++) {
                    if(shootVertical[i][j]==1) {
                        lcd.setPixel(i+shoot[x][2],j+shoot[x][3]);  //loops through and sets pixels to the assigned location
                    }
                }
            }

        }
        if(shoot[x][1]==2 || shoot[x][1]==6) {      //checks to see if ship is facing right or left
            for(int i=0; i<2; i++) {
                for(int j=0; j<1; j++) {
                    if(shootHorizontal[i][j]==1) {
                        lcd.setPixel(i+shoot[x][2],j+shoot[x][3]);     //sets the horizontal bullet array
                    }
                }
            }
        }
        if(shoot[x][1]==1 || shoot[x][1]==5) {              //checks if diagonal1 is the array to use
            for(int i=0; i<2; i++) {
                for(int j=0; j<2; j++) {
                    if(shootDiaganol1[i][j]==1) {
                        lcd.setPixel(i+shoot[x][2],j+shoot[x][3]);      //sets the diagonal1 array
                    }
                }
            }

        }

        if(shoot[x][1]==3 || shoot[x][1]==7) {              //diagonal2 is called for these directions
            for(int i=0; i<3; i++) {
                for(int j=0; j<3; j++) {
                    if(shootDiaganol2[i][j]==1) {
                        lcd.setPixel(i+shoot[x][2],j+shoot[x][3]);      //diagonal2 is set

                    }
                }
            }
        }
    }
}

///a function to move the asteroids and check for collisions
void asteroidMove()
{

    /* the array asteroid[5][8] is used to track and move asteroids the first coloumn is asteroid number
       the second coloumn determines asteroid type, the third coloumn is asteroid direction
       then fourth and fifth determine x and y coordinates
       */

    srand(timer.read_us()); //a random number is generated using the mbed's internal timer as a seed
    int r = rand()%8;       //the variable r is a random number between 0 and 7 which determines where the asteroid comes from
    int number = rand()%4; //the variable number is a random number from 0 to 3 which determines the type of asteroid


    for (int x = 0; x<8; x++) {    //loops through each row in the array

        if(asteroid[x][0] !=0) {        //checks to see if the asteroid has not previously been assigned a number
            if(asteroid[x][2]==0) {     //if the astroid has no assigned type it is assigned here
                if(r==0) {
                    asteroid[x][2]=1;   //a random number 0 assigns the direction value to be 1
                }
                if(r==1) {
                    asteroid[x][2]=2;   //a random number 1 assigns the direction value to be 2
                }
                if(r==2) {
                    asteroid[x][2]=3;   //a random number 2 assigns the direction value to be 3
                }
                if(r==3) {
                    asteroid[x][2]=4;   //a random number 3 assigns the direction value to be 4
                }
                if(r==4) {
                    asteroid[x][2]=5;   //a random number 4 assigns the direction value to be 5
                }
                if(r==5) {
                    asteroid[x][2]=6;   //a random number 5 assigns the direction value to be 6
                }
                if(r==6) {
                    asteroid[x][2]=7;   //a random number 6 assigns the direction value to be 7
                }
                if(r==7) {
                    asteroid[x][2]=8;   //a random number 7 assigns the direction value to be 8
                }


                ///the random variable number is used to assign the type of asteroid
                if(number == 0) {
                    asteroid[x][1]=1;   //0 gives asteroid type 1
                }
                if(number == 1) {
                    asteroid[x][1]=2;   //1 gives asteroid type 2
                }
                if(number == 2) {
                    asteroid[x][1]=3;   //2 gives asteroid type 3
                }
                if(number == 3) {
                    asteroid[x][1]=4;   //3 gives asteroid type 4
                }
            }


            switch(asteroid[x][2]) {           //the case is selected based on which direction the asteroid comes from determined by r


                case 1:                 //asteroid from top left

                    int flag = 0;


                    if (flag == 1) {
                        flag=0;         //the flag is cleared and bypasses the setting of the array
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) {    //checks to see if there is a collision with the ship
                        game_over = 1;  //game over is increased to 1 to end the game
                    }

                    else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=1;
                        }
                        asteroid[x][3]=asteroid[x][3]+1;    //asteroids x coordinate increase to move right

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=1;
                        }
                        asteroid[x][4]=asteroid[x][4]+1;   //asteroids y coordinates increase to move down
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 2:                 //asteroid from top


                    if (flag == 1) {
                        flag=0;                 //the flag is cleared and the setting of asteroids is bypassed
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) {        //checks to see if the asteroid collides with the ship
                        game_over = 1;      //if the ship is hit the game over is increased to break the while loop
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=20;
                        }
                        asteroid[x][3]=asteroid[x][3];      //moving vertically so x coordinates don't change

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=1;
                        }
                        asteroid[x][4]=asteroid[x][4]+1;    //moving down so y coordinates need to increase
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 3:             //asteroid from top right


                    if (flag == 1) {
                        flag=0;             //the flag is cleared and the setting of asteroids is bypassed
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) { //checks for collisions with the ship
                        game_over=1;        //game over is increased to one to break the while loop
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=48;
                        }
                        asteroid[x][3]=asteroid[x][3]-1;        //asteroid is moving left so the x coordinate decreases

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=1;
                        }
                        asteroid[x][4]=asteroid[x][4]+1;        //asteroid is moving from top so the y coordinate increases
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 4:         //asteroid from right


                    if (flag == 1) {
                        flag=0;             //the flag is cleared and astroids being set is bypassed
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>= 24)) {        //checks if the ship has been hit
                        game_over = 1;       //game_over is increased to 1 to break the while loop
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=48;
                        }
                        asteroid[x][3]=asteroid[x][3]-1;        //the x coordinate decreases to move the ship left

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=20;
                        }
                        asteroid[x][4]=asteroid[x][4];          // no vertical movement so stays constant
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 5:     //asteroid from down right


                    if (flag == 1) {
                        flag=0;                     //flag is cleared and setting of asteroids is bypassed
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) {      //checks if the asteroid has collided with the ship
                        game_over = 1;      //game_over is increased breaking the while loop and causing the game to end
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=48;
                        }
                        asteroid[x][3]=asteroid[x][3]-1;        //x coordinates decrease to move ship left

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=48;
                        }
                        asteroid[x][4]=asteroid[x][4]-1;        //y coordinates decrease to move ship up
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 6:     //asteroid from bottom


                    if (flag == 1) {
                        flag=0;             //the flag is cleared and the setting of the asteroids is bypassed
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) {        //checks to see if the ship has been hit
                        game_over = 1;  //game over is increased to 1 which ends the game
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=20;
                        }
                        asteroid[x][3]=asteroid[x][3]; //as no horizontal movement the x coordinates are constant

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=48;
                        }
                        asteroid[x][4]=asteroid[x][4]-1;        //the y coordinate decreases to cause the asteroid to move up
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 7:                 //asteroid from bottom left

                    if (flag == 1) {
                        flag=0;                 //clears the flag and bypasses the setting of asteroids
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) {      //checks to see if there is a collision with the ship
                        game_over=1;          //raises game over to 1 to break the while loop
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=1;
                        }
                        asteroid[x][3]=asteroid[x][3]+1;        //x coordinates increase to move asteroid right

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=48;
                        }
                        asteroid[x][4]=asteroid[x][4]-1;        //y coordinates decrease to move asteroid up
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }

                case 8:         //asteroid from left

                    if (flag == 1) {
                        flag=0;             //clears the flag and bypasses the asteroid placement
                    } else if((asteroid[x][3]<=24)and (asteroid[x][3]+9>= 24) and (asteroid[x][4]<=24) and (asteroid[x][4]+9>=24)) {   //checks to see if the ship has been hit
                        game_over = 1;      //game over is increased to 1 to break the while loop
                    } else {
                        //checks if asteroids x coordinates have been set if not sets them
                        if(asteroid[x][3]==0) {
                            asteroid[x][3]=1;
                        }
                        asteroid[x][3]=asteroid[x][3]+1;        //x coordinates increase to move ship right

                        //checks if asteroids y coordinates have been set if not sets them
                        if(asteroid[x][4]==0) {
                            asteroid[x][4]=20;
                        }
                        asteroid[x][4]=asteroid[x][4];      //y coordinates stay constant as there is no vertical movement
                        for (int z=0; z<8; z++) {
                            if((asteroid[x][3]<=shoot[z][2])and ((asteroid[x][3]+9)>= shoot[z][2]) and (asteroid[x][4]<=shoot[z][3]) and ((asteroid[x][4]+9)>= shoot[z][3])) { // checks to see if an asteroid collides with a bullet
                                asteroid[x][0]=0;       //the asteroid number is erased
                                asteroid[x][1]=0;       //the asteroid type is erased
                                asteroid[x][2]=0;       //the asteroid direction is erased
                                asteroid[x][3]=0;       //the asteroids x position is erased
                                asteroid[x][4]=0;       //the asteroids y positionis erased
                                shoot[z][0]=0;          //the bullets number is erased
                                shoot[z][1]=0;          //the bullets direction is erased
                                shoot[z][2]=0;          //the bullets x coordinate is erased
                                shoot[z][3]=0;          // the bulets y coordinate is erased
                                flag = 1;       //the flag is raised
                            }
                        }
                        break;
                    }
            }

            //for asteroid type 1 the code loops through the array for asteroid1 and sets the pixels
            if (asteroid[x][1] == 1) {
                for (int i = 0; i<9; i++) {
                    for (int j=0; j<9; j++) {
                        if (asteroid1[i][j]==1) {
                            lcd.setPixel(i+asteroid[x][3],j+asteroid[x][4]);
                        }
                    }
                }
            }
            //for asteroid type 2 the code loops through the array for asteroid2 and sets the pixels
            if(asteroid[x][1] == 2) {
                for (int i = 0; i<8; i++) {
                    for (int j=0; j<9; j++) {
                        if (asteroid2[i][j]==1) {
                            lcd.setPixel(i+ asteroid[x][3],j+asteroid[x][4]);
                        }
                    }
                }

            }
            //for asteroid type 3 the code loops through the array for asteroid3 and sets the pixels
            if(asteroid[x][1] == 3) {
                for (int i = 0; i<9; i++) {
                    for (int j=0; j<9; j++) {
                        if (asteroid3[i][j]==1) {
                            lcd.setPixel(i+ asteroid[x][3],j+asteroid[x][4]);
                        }
                    }
                }

            }
            //for asteroid type 4 the code loops through the array for asteroid4 and sets the pixels
            if(asteroid[x][1] == 4) {
                for (int i = 0; i<9; i++) {
                    for (int j=0; j<9; j++) {
                        if (asteroid4[i][j]==1) {
                            lcd.setPixel(i+ asteroid[x][3],j+asteroid[x][4]);
                        }
                    }
                }
            }
        }

    }

}
void game()
{



    if (printFlag == 1) {
        timer.start();
        printFlag = 0;      //resets printFlag

        //the joystick direction determines the direction of the FSM
        if(joystick.direction == Up) {
            direction = UP;
        } else if(joystick.direction == Right) {
            direction = RIGHT;
        } else if(joystick.direction == Down) {
            direction = DOWN;
        } else if(joystick.direction == Left) {
            direction = LEFT;
        } else if(joystick.direction == Upright) {
            direction = UPRIGHT;
        } else if(joystick.direction == Downright) {
            direction = DOWNRIGHT;
        } else if(joystick.direction == Downleft) {
            direction = DOWNLEFT;
        } else if(joystick.direction == Upleft) {
            direction = UPLEFT;
        }
    }

//loops through coloumn 48 to draw a line to make the playing area square
    for (int j = 0;j < WIDTH;j++) {
        lcd.setPixel(48,j);
    }
    lcd.drawRect(48,0,35,47,1); 
    // set shipDirection of current state (use dot syntax to access struct members)
    shipDirection = fsm[state].shipDirection;
    // set the next state depending on direction
    state = fsm[state].next_state[direction];

    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    if (shipDirection == 6) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipUp[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }
    }
    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else if (shipDirection == 5) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipUR[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }
    }
    ///from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else if (shipDirection == 4) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipRight[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }

    }
    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else if (shipDirection == 3) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipDR[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }

        }
    }
    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else if (shipDirection == 2) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipDown[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }

    }
    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else if (shipDirection == 1) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipDL[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }

    }
    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else if (shipDirection == 0) {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipLeft[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }

    }
    //from the FSM the next direction is chosen and the code loops through the appropriate array to face the ship in that direction
    else {
        for (int i = 0; i<9; i++) {
            for (int j=0; j<9; j++) {
                if (shipUL[i][j]==1) {
                    lcd.setPixel(i+20,j+20);
                }
            }
        }

    }

    srand(timer.read_us());         //using the timer on the mbed a random number is generated

    int random = rand()%30;        //a random number from 1 to 30 is generated
    if(random ==1) {                //there is a 10% chance of an asteroid every iteration of code
        for(int x = 0; x<8; x++) {      //checks to see what number asteroid to place
            if (asteroid[x][0]==0) {
                asteroid[x][0]= x+1;     //if there is not an asteroid in the selected row then one will be placed there
                break;
            }
        }
    }

    asteroidMove(); //the asteroid move function is called

    if(g_b1_flag) {             //checks to see if the interrupt has been pressed
        g_b1_flag = 0;          //after the interupt the flag is reset
        for (int x = 0; x<10; x++) {
            if (shoot[x][0] == 0) {     //checks to see if there is a bullet in the row of the shoot array
                bullet_number++;        //the bullet number is increased by 1
                shoot[x][0]=bullet_number;  //the bullet number is placed in the shoot array
                shoot[x][1]=shipDirection;  //the direction the ship is facing is recorded in the shoot array
                break;
            }
        }
    }

    shoots();           //calls the shoots function
    checkbullet();      //calls the check bullet function
    timer.stop();       //makes the timer stop

}



//a function to check if the bullet is still on screen
void checkbullet()
{
    for (int x = 0; x<10; x++) {            //loops through each row of the shoot array
        if ((shoot[x][2] == 0)or(shoot[x][3] == 0)or(shoot[x][2] == 48) or(shoot[x][3] == 48)) {            //checks the 4 orders
            shoot[x][0]=0;  //bullet_number is erased
            shoot[x][1]=0;  //shipDirection is erased
            shoot[x][2]=0;  //bullet x coordinate is erased
            shoot[x][3]=0;  //bullet y coordinate is erased

        }
    }
}
//void checkAsteroid()
//{
//    for (int x = 0; x<8; x++) {            //loops through each row of the shoot array
//        if ((asteroid[x][3] == 0)or(asteroid[x][4] == 0)or(asteroid[x][3] == 48) or(asteroid[x][4] == 48)) {            //checks the 4 orders
//            asteroid[x][0]=0;  //bullet_number is erased
//            asteroid[x][1]=0;  //shipDirection is erased
//            asteroid[x][2]=0;  //bullet x coordinate is erased
//            asteroid[x][3]=0;  //bullet y coordinate is erased
//            asteroid[x][4]=0;
//        }
//    }
//}