/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Shows examples of creating Doxygen documentation.
@brief Revision 1.0.
@author Martin Woodhams
@date   March 2015
*/

#ifndef ARRAYS_H
#define ARRAYS_H

int shoot[10][4];   /*!< this is the 10 by 4 array that is used to postion and move bullets*/
int asteroid[8][5];     /*!<this 8 by 5 array is used to positon and move the asteroids*/

int shootHorizontal[1][2]= {
    {1,1}
};              /*!<an array to call the horizontal bullets*/

int shootVertical[2][1]={
    {1},
    {1}
};             /*!<an array to call the vertical bullets*/

int shootDiaganol1[2][2]={  
    {0,1},
    {1,0}
};               /*!< an array to call the up right diagonal*/

int shootDiaganol2[3][3]={  
    {1,0,0},
    {0,1,0},
    {0,0,1}
};              /*!<an array to call the up left diagonal*/

int shipUp [9][9]= {
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,1,1,1,1,1,0,0},
    {0,1,1,1,1,1,1,1,0},
    {1,1,1,0,0,0,1,1,1},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0}
};              /*!< an array that sets the ship in an upward facing position*/

int shipUR [9][9]= {
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {1,1,1,1,1,1,0,0,0},
    {1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,0,0,0},
    {0,0,0,0,1,1,0,0,0},
    {0,0,0,0,1,1,0,0,0}
};              /*!< an array that sets the ship to face the upper right hand corner */

int shipRight [9][9]= {
    {0,0,1,0,0,0,0,0,0},
    {0,0,1,1,0,0,0,0,0},
    {0,0,1,1,1,0,0,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,0,1,1,1,1,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,1,1,1,0,0,0,0},
    {0,0,1,1,0,0,0,0,0},
    {0,0,1,0,0,0,0,0,0}
};              /*!< an array that sets the ship to face right*/

int shipDR [9][9]= {
    {0,0,0,0,1,1,0,0,0},
    {0,0,0,0,1,1,0,0,0},
    {0,0,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,0,0,0},
    {1,1,1,1,1,1,0,0,0},
    {1,1,1,1,1,1,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0}
};              /*!< an array that sets the ship to face the down right corner*/

int shipDown [9][9]= {
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {1,1,1,0,0,0,1,1,1},
    {0,1,1,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0}
};              /*!< an array that sets the ship to face down*/

int shipDL [9][9]= {
    {0,0,0,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,0,0},
    {0,0,0,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,1,1},
    {0,0,0,1,1,1,1,1,1},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0}
};              /*!< an array that sets the ship to face the bottom left corner*/

int shipLeft [9][9]= {
    {0,0,0,0,0,0,1,0,0},
    {0,0,0,0,0,1,1,0,0},
    {0,0,0,0,1,1,1,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,1,1,1,1,0,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,1,1,0,0},
    {0,0,0,0,0,1,1,0,0},
    {0,0,0,0,0,0,1,0,0}
};              /*!< an array that sets the ship to face left*/

int shipUL [9][9]= {
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,0,0,0,0,0,0},
    {0,0,0,1,1,1,1,1,1},
    {0,0,0,1,1,1,1,1,1},
    {0,0,0,1,1,1,1,0,0},
    {0,0,0,1,1,1,1,0,0},
    {0,0,0,1,1,0,0,0,0},
    {0,0,0,1,1,0,0,0,0}
};             /*!< an array that sets the ship to face the top left corner*/




int asteroid1 [9][9]= {
    {0,1,1,1,1,1,1,0,0},
    {1,1,0,0,0,0,1,0,0},
    {1,0,0,0,0,0,1,1,1},
    {1,0,0,0,0,0,0,0,1},
    {1,1,1,0,0,0,0,0,1},
    {0,0,1,0,0,0,0,1,1},
    {0,0,1,0,0,0,0,1,0},
    {0,0,1,0,0,0,1,1,0},
    {0,0,1,1,1,1,1,0,0},
};          /*!< an array that sets array type 1*/

int asteroid2 [9][9]= {
    {0,0,0,1,1,1,0,0,0},
    {0,1,0,1,0,1,1,0,0},
    {0,1,1,1,0,0,1,1,0},
    {1,1,0,0,0,0,0,1,0},
    {1,0,0,0,0,0,0,1,1},
    {1,1,1,0,0,0,0,0,1},
    {1,0,1,0,0,0,0,1,0},
    {0,0,0,1,0,0,1,1,0},
    {0,0,1,1,1,1,1,0,0},
};          /*!< an array that sets array type 2*/

int asteroid3 [9][9]= {
    {0,0,1,0,1,1,1,0,0},
    {0,1,0,1,1,0,1,0,0},
    {0,1,0,0,0,0,1,0,1},
    {1,1,0,0,0,0,0,1,1},
    {1,0,0,0,0,0,0,0,1},
    {1,0,0,0,0,0,0,1,1},
    {1,1,1,0,0,0,0,1,0},
    {0,0,1,0,0,0,1,1,0},
    {0,0,0,1,1,1,1,0,0},
};          /*!< an array that sets array type 3*/

int asteroid4 [9][9]= {
    {0,0,0,0,1,0,0,0,0},
    {0,1,1,1,1,1,1,0,0},
    {0,0,1,1,0,0,1,0,0},
    {0,1,0,0,0,0,1,1,0},
    {1,0,0,0,0,0,0,0,1},
    {0,1,1,0,0,0,0,1,0},
    {0,0,1,1,0,0,1,1,0},
    {0,0,0,1,0,1,1,1,0},
    {0,0,0,0,1,0,0,0,0},
    
};          /*!< an array that sets array type 4*/

#endif