/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Shows examples of creating Doxygen documentation.
@brief Revision 1.0.
@author Liqian, Xiang
@date   May 2016
*/

#include "mbed.h"
#include "N5110.h"
#include <stdio.h>
#include <stdlib.h>

// change this to alter tolerance of joystick direction
#define DIRECTION_TOLERANCE 0.05

//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
/**  
@namespace N5110 lcd
@brief lcd connection
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
// Can also power (VCC) directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin

// connections for joystick
/**  
@namespace button
@brief button for start game
*/
DigitalIn button(PTB11);
/**  
@namespace xPot
@brief shift rectangle at x-axis
*/
AnalogIn xPot(PTB2);
/**  
@namespace yPot
@brief shift rectangle at y-axis
*/
AnalogIn yPot(PTB3);


/**  
@namespace pollJoystick
@brief timer to regularly read the joystick
*/
Ticker pollJoystick;

/**  
@namespace ball_one
@brief timer to regularly shift balls
*/
Ticker ball_one;

/**  
@namespace ticker
@brief let LED flash
*/
Ticker ticker;

/**  
@namespace red_led
@brief lcd connection
*/
PwmOut red_led(PTC2);

/**  
@namespace buzzer
@brief buzzer connection
*/
PwmOut buzzer(PTA2);



// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
/**  
@namespace joystick
@brief create joystick project
*/
Joystick joystick;
volatile int printFlag = 0;/*!<create struct variable printFlag */
volatile int ballFlag = 0;/*!<create struct variable ballFlag */
volatile int flag = 0;/*!<create struct variable Flag */
int recx = 40;/*!< the abscissa of the left point of the rectangle */
int recy = 47;/*!< the ordinates of the left point of the rectangle */



// function prototypes
/**
read default positions of the joystick to calibrate later readings
*/
void calibrateJoystick();
/**
control the joystick
*/
void updateJoystick();
/**
create struct variable function
*/
void updateBall();
/**
condition for ending the game
*/
void disappearBall();
/**
let red LED turn on
*/
void red();