#include "main.h"
// condition for ending the game
void disappearBall()
{
    if (lcd.getPixel(recx+1,recy-1)||lcd.getPixel(recx+2,recy-1)||lcd.getPixel(recx+3,recy-1)||lcd.getPixel(recx+4,recy-1)||lcd.getPixel(recx+5,recy-1)) {
        flag = 1;
    } else {
        flag = 0;
    }
}

// let red LED turn on
void red()
{
    red_led =!red_led;
}

//create struct variable function
void updateBall()
{
    ballFlag = 1;
}

// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

//control the joystick
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;

    // calculate direction depending on x,y values
    // tolerance allows flag little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}

int main()
{
    
    button.mode(PullDown);
    // first need to initialise display
    lcd.init();
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(0.5); // put LED backlight on 50%
    // can directly print strings at specified co-ordinates
    lcd.printString("Dodgeball",1,1);
    lcd.printString("Xiang Liqian",1,2);
    lcd.printString("200986035",1,3);
    lcd.refresh();
    wait(2.0);  // wait 2s move to neat page
    lcd.clear();  // clear screen
    lcd.printString("Loading...",8,1);

    char buffer[14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
                     // so can display a string of a maximum 14 characters in length
    for (int a = 0; a <= 100 ; a=a+10) {
        sprintf(buffer,"%d %%",a);
        lcd.printString(buffer,30,4);
        wait(0.2);
    }
    lcd.clear();
    
    while(1) {
        lcd.printString("Press button",5,1);
        lcd.printString("--PLAY--",20,3);
        
        //put button to let game start
        if(button) {
            break;
        }
    }

    calibrateJoystick();  // get centred values of joystick
    ticker.attach(&red,0.1); // read ticker 10 times per second
    pollJoystick.attach(&updateJoystick,0.2);  // read joystick 5 times per second
    ball_one.attach(&updateBall,0.3); // read ball_one one time per 0.3 second

    int x1,x2,x3,x4,x5,x6;
    int y1,y2,y3,y4,y5,y6;
    int g = 0;
    int c2=0;
    int c3=0;
    int c4=0;
    int c5=0;
    int c6=0;

    y1 = 0;
    y2 = 0;
    y3 = 0;
    y4 = 0;
    y5 = 0;
    y6 = 0;

    x1 = rand ()%80+4;
    x2 =rand ()%80+4;
    x3 = rand ()%80+4;
    x4 =rand ()%80+4;
    x5 =rand ()%80+4;
    x6 =rand ()%80+4;

    while(1) {
        // draw rectangle 
        lcd.drawRect(recx,recy,5,1,1);
        if(ballFlag) {
            ballFlag=0;
            c2++;
            c3++;
            c4++;
            c5++;
            c6++;
            lcd.clear();
            
            // check when small ball fall down 
            if (c6>=30) {
                
                lcd.drawCircle(x6,y6,1,1); // draw small circle
                y6=y6+2;
            }
            
            // check when big ball fall down
            if (c5>=25) {

                lcd.drawCircle(x5,y5,2,1); // draw big circle
                y5=y5+3;
            }
            
            if (c4>=20) {
                
                lcd.drawCircle(x4,y4,1,1);
                y4=y4+2;
            }


            if (c3>=15) {

                lcd.drawCircle(x3,y3,2,1);
                y3=y3+3;
            }

            if (c2>=5) {
                
                lcd.drawCircle(x2,y2,1,1);
                y2=y2+2;
            }

            lcd.drawCircle(x1,y1,2,1);
            y1 = y1+3;

             //check how the loop works 
             if (y6 >= 51) {
                c6=0;
                y6 = 0;
                x6 =rand ()%80+4;
            }else if (y5 >= 51) {
                c5=0;
                y5 = 0;
                x5 =rand ()%80+4;
            }else if (y4 >= 51) {
                c4=0;
                y4 = 0;
                x4 =rand ()%80+4;
            } else if (y3 >= 51) {
                c3=0;
                y3 = 0;
                x3 =rand ()%80+4;
            } else if (y2 >= 51) {
                c2=0;
                y2 = 0;
                x2 =rand ()%80+4;
            } else if (y1 >= 51) {
                y1=0;
                x1 = rand ()%80+4;
            }

            lcd.refresh();
        }

        if (printFlag)  {  // if flag set, clear flag and print joystick values to serial port

            printFlag = 0;


            // check joystick direction
            if (joystick.direction == UP) {

                lcd.drawRect(recx,recy,5,1,2);
                recx -=4; //move the joystick 
                char soure [14]; // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
                sprintf(soure,"%d %",g);
                g++;

                disappearBall();
                
                if(flag) {
                    lcd.clear();
                    lcd.printString("Game over",15,2);
                    lcd.printString("Soure:",15,3);
                    lcd.printString(soure,50,3);
                    buzzer.period(0.001); //let buzzer work 1000 times per second
                    buzzer = 0.5; //volume of the buzzer
                    break;
                }

                lcd.drawRect(recx,recy,5,1,1);

            }

            if (joystick.direction == DOWN) {

                lcd.drawRect(recx,recy,5,1,2);
                recx +=4;
                char soure [14];
                sprintf(soure,"%d %",g);
                g++;

                disappearBall();
                if(flag) {
                    lcd.clear();
                    lcd.printString("Game over",15,2);
                    lcd.printString("Soure:",15,3);
                    lcd.printString(soure,50,3);
                    buzzer.period(0.001);
                    buzzer = 0.5;
                    break;
                }

                lcd.drawRect(recx,recy,5,1,1);
            }

            if (joystick.direction == LEFT) {
                disappearBall();
                char soure [14];
                sprintf(soure,"%d %",g);
                g++;
                if(flag) {
                    lcd.clear();
                    lcd.printString("Game over",15,2);
                    lcd.printString("Soure:",15,3);
                    lcd.printString(soure,50,3);
                    buzzer.period(0.001);
                    buzzer = 0.5;
                    break;
                }
            }

            if (joystick.direction == RIGHT) {
                disappearBall();
                char soure [14];
                sprintf(soure,"%d %",g);
                g++;
                if(flag) {
                    lcd.clear();
                    lcd.printString("Game over",15,2);
                    lcd.printString("Soure:",15,3);
                    lcd.printString(soure,50,3);
                    buzzer.period(0.001);
                    buzzer = 0.5;
                    break;
                }
            }

            if (joystick.direction == CENTRE) {
                disappearBall();
                char soure [14];
                sprintf(soure,"%d %",g);
                g++;
                if(flag) {
                    lcd.clear();
                    lcd.printString("Game over",15,2);
                    lcd.printString("Soure:",15,3);
                    lcd.printString(soure,50,3);
                    buzzer.period(0.001);
                    buzzer = 0.5;
                    break;
                }
            }

            if (joystick.direction == UNKNOWN) {
                disappearBall();
                char soure [14];
                sprintf(soure,"%d %",g);
                g++;
                if(flag) {
                    lcd.clear();
                    lcd.printString("Game over",15,2);
                    lcd.printString("Soure:",15,3);
                    lcd.printString(soure,50,3);
                    buzzer.period(0.001);
                    buzzer = 0.5;
                    break;
                }
            }


        }

        lcd.refresh();
    }
}



