/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.

@brief Revision 1.0.
@author liyuan,He
@date   May 2016
*/
#include "mbed.h"
#include "N5110.h"
#include <stdio.h>
#include <stdlib.h>

//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
/**  
@namespace N5110 lcd
@brief lcd connection
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
// Can also power (VCC) directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin

// change this to alter tolerance of joystick direction
#define DIRECTION_TOLERANCE 0.05

// connections for joystick
/**  
@namespace joystickbutton
@brief useless
*/
DigitalIn joystickbutton(PTB10);
/**  
@namespace xPot
@brief control the x-axis movement of circle
*/
AnalogIn xPot(PTB2);
/**  
@namespace yPot
@brief control the y-axis movement of circle
*/
AnalogIn yPot(PTB3);

// timer to regularly read the joystick
/**  
@namespace pollJoystick
@brief the movement of joystick
*/
Ticker pollJoystick;
/**  
@namespace ticker
@brief the time of led turn on
*/
Ticker ticker;
// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
/**  
@namespace DirectionName
@brief control the direction of circle
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};
/**  
@namespace Joystick
@brief know the current value of circle
*/
// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
Joystick joystick;

int printFlag = 0;/*!< print flag set in ISR */

// function prototypes
/**
set the position of joystick
*/
void calibrateJoystick();
/**
joystick connection
*/
void updateJoystick();

int circle_x=10;/*!<the x-axis of circle's centre */
int circle_y=10;/*!<the y-axis of circle's centre */

/**
 the condition of Collision (circle and rect)
*/
int detectBounce();
int flag;
int score=0;/*!<circle goes more, the score will be high */
/**  
@namespace blue_led
@brief lcd connection
*/
PwmOut blue_led(PTC2);
/**
let led turns on
*/
void blue();