#include "main.h"
int detectBounce() //check the pixel at this position
{
    if (lcd.getPixel(circle_x+3,circle_y-1)||lcd.getPixel(circle_x+3,circle_y)||lcd.getPixel(circle_x+3,circle_y+1) ) {
        return 1; 
    }
    if (lcd.getPixel(circle_x-3,circle_y-1)||lcd.getPixel(circle_x-3,circle_y)||lcd.getPixel(circle_x-3,circle_y+1) ) {
        return 1;
    }
    if (lcd.getPixel(circle_x-1,circle_y+3)||lcd.getPixel(circle_x,circle_y+3)||lcd.getPixel(circle_x+1,circle_y+3) ) {
        return 1;
    }
    if (lcd.getPixel(circle_x-1,circle_y-3)||lcd.getPixel(circle_x,circle_y-3)||lcd.getPixel(circle_x+1,circle_y-3) ) {
        return 1;
    } else {
        return 0;
    }
}


// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    joystickbutton.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = joystickbutton;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}



void blue()
{
    blue_led = !blue_led; //turn on the blue led
    }
PwmOut buzzer (PTA2);



int main()
{
    // first need to initialise display
    lcd.init();
    // these are default settings so not strictly needed
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(1.0); // put LED ccklight on 50%
    joystickbutton.mode(PullDown);
    // can directly print strings at specified co-ordinates
    lcd.printString("Flexible ball",0,2);  //name, the col, and the line
    buzzer.period(1.0/1046.0);  
    buzzer.period(1.0/1175.0);
    
    buzzer = 0.5;  // turn on (square wave)

    wait(2.0);

    buzzer = 0.0;  // turn off (0% duty cycle)
    // so can display a string of a mbimum 14 characters in length
    // or create formatted strings - ensure they aren't more than 14 characters long
    lcd.refresh();

    wait(2.0);  // wait 2s move to neat page
    lcd.clear();  // clear screen
    lcd.printString("Loading...",6,1);
    wait(2.0);


    lcd.clear();


    int recx1=70;    //create 4 rectangle
    int rech1=17;

    int recx2=30;
    int rech2=17;

    int recx3=45;
    int rech3=17;

    int recx4=60;
    int rech4=17;

    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    while(1) {



        if(recx1<0) {
            recx1=82;
            rech1 = rand() % 24;        //create new rectangle have random height
        }
        if(recx2<0) {
            recx2=82;
            rech2 = rand() % 24+3;
        }
        if(recx3<0) {
            recx3=82;
            rech3 = rand() % 24+4;
        }
        if(recx4<0) {
            recx4=82;
            rech4 = rand() % 24+5;
        }

        recx1--;      // when rec move to 0, it will show at right of screen
        recx2--;
        recx3--;
        recx4--;

        lcd.clear();
        lcd.drawRect(recx1,0,1,rech1,1);   //draw new rectangle
        lcd.drawRect(recx2,30,1,rech2,1);
        lcd.drawRect(recx3,40,1,rech3,1);
        lcd.drawRect(recx4,0,1,rech4,1);
        lcd.drawCircle(circle_x,circle_y,2,1);  //draw the circle
        lcd.refresh();


        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;

            // check joystick direction
        
            if (joystick.direction == UP) {
                lcd.drawCircle(circle_x,circle_y,2,2);
                circle_y -=3;
                lcd.drawCircle(circle_x,circle_y,2,1);
                flag=detectBounce();   // condition of collision
                if (flag) {
                    lcd.clear();
                    lcd.printString("Game Over",2,2);    
                    lcd.printString("score=",2,3);
                    char s[14];
                    sprintf(s,"%d",score);     //show the score of game
                    lcd.printString(s,45,3);
                    lcd.refresh();
                    ticker.attach(&blue,0.5);   // the blue led will turn on when game over
                    buzzer.period(1.0/1046.0);  //the buzzer will turn on at this frequency
                    buzzer.period(1.0/1175.0);
                    buzzer = 0.5;  // turn on (square wave)
                    wait(2.0);
                    buzzer = 0.0;  // turn off (0% duty cycle)
                    break;
                }
            }

            if (joystick.direction == DOWN) {
                lcd.drawCircle(circle_x,circle_y,2,2);
                circle_y +=3;
                lcd.drawCircle(circle_x,circle_y,2,1);
                flag=detectBounce(); // condition of collision
                if (flag) {
                    lcd.clear();
                    lcd.printString("Game Over",2,2);//show the game over
                    lcd.printString("score=",2,3);
                    char s[14];
                    sprintf(s,"%d",score);
                    lcd.printString(s,45,3);
                    lcd.refresh();
                    ticker.attach(&blue,0.5);  //the led blue will turn on
                    buzzer.period(1.0/1046.0);  //the buzzer will turn on
                    buzzer.period(1.0/1175.0);
                    buzzer = 0.5;  // turn on (square wave)
                    wait(2.0);
                    buzzer = 0.0;  // turn off (0% duty cycle)
                    break;
                }
            }

            if (joystick.direction == LEFT) {
                lcd.drawCircle(circle_x,circle_y,2,2);
                circle_x -=3;
                lcd.drawCircle(circle_x,circle_y,2,1);
                flag=detectBounce(); // condition of collision
                if (flag) {
                    lcd.clear();
                    lcd.printString("Game Over",2,2);
                    lcd.printString("score=",2,3);
                    char s[14];
                    sprintf(s,"%d",score);
                    lcd.printString(s,45,3);
                    lcd.refresh();
                    ticker.attach(&blue,0.5);
                    buzzer.period(1.0/1046.0);  
                    buzzer.period(1.0/1175.0);
                    buzzer = 0.5;  // turn on (square wave)
                    wait(2.0);
                    buzzer = 0.0;  // turn off (0% duty cycle)
                    break;
                }
            }

            if (joystick.direction == RIGHT) {
                lcd.drawCircle(circle_x,circle_y,2,2);
                circle_x +=3;
                lcd.drawCircle(circle_x,circle_y,2,1);
                flag=detectBounce();  // condition of collision
                if (flag) {
                    lcd.clear();
                    lcd.printString("Game Over",2,2);
                    lcd.printString("score=",2,3);
                    char s[14];
                    sprintf(s,"%d",score);
                    lcd.printString(s,45,3);
                    lcd.refresh();
                    ticker.attach(&blue,0.5);
                    buzzer.period(1.0/1046.0);  
                    buzzer.period(1.0/1175.0);
                    buzzer = 0.5;  // turn on (square wave)
                    wait(2.0);
                    buzzer = 0.0;  // turn off (0% duty cycle)
                    break;
                }
            }

            if (joystick.direction == CENTRE) {
                lcd.drawCircle(circle_x,circle_y,2,1);
                flag=detectBounce();  // condition of collision
                if (flag) {
                    lcd.clear();
                    lcd.printString("Game Over",2,2);
                    lcd.printString("score=",2,3);
                    char s[14];
                    sprintf(s,"%d",score);
                    lcd.printString(s,45,3);
                    lcd.refresh();
                    ticker.attach(&blue,0.5);
                    buzzer.period(1.0/1046.0);  
                    buzzer.period(1.0/1175.0);
                    buzzer = 0.5;  // turn on (square wave)
                    wait(2.0);
                    buzzer = 0.0;  // turn off (0% duty cycle)
                    break;
                }
            }

            if (joystick.direction == UNKNOWN) {
                lcd.drawCircle(circle_x,circle_y,2,1);
                flag=detectBounce(); // condition of collision
                if (flag) {
                    lcd.clear();
                    lcd.printString("Game Over",2,2);
                    lcd.printString("score=",2,3);
                    char s[14];
                    sprintf(s,"%d",score);
                    lcd.printString(s,45,3);
                    lcd.refresh();
                    ticker.attach(&blue,0.5); // the led will turn on 
                    buzzer.period(1.0/1046.0);  //the buzzer will turn on
                    buzzer.period(1.0/1175.0);
                    buzzer = 0.5;  // turn on (square wave)
                    wait(2.0);
                    buzzer = 0.0;  // turn off (0% duty cycle)
                    break;
                }
            }

        }
        score+=1;   //the score will add every time
        lcd.refresh();
        wait(0.2);
        

    }
}