
/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Acknowledgements to Craig A. Evans's N5110 Library.
@brief Acknowledgements to Craig A. Evans's SRF02 Library.
@brief Revision 1.0.
@author Kai Yuan
@date   May 2016
*/#include "mbed.h"
#include "SRF02.h"
#include "N5110.h"
#include "SDFileSystem.h"

/**
@namespace SRF02_sensor
@brief GPIO output for status LED
*/
SRF02 sensor(I2C_SDA,I2C_SCL);





Serial serial(USBTX, USBRX);
/**
@namespace N5110_lcd
@brief LCD Display
*/
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
/**
@namespace r_led
@brief red led
*/
DigitalOut r_led(LED_RED);
/**
@namespace g_led
@brief green led
*/
DigitalOut g_led(LED_GREEN);
/**
@namespace b_led
@brief blue led
*/
DigitalOut b_led(LED_BLUE);
// K64F on-board switches
/**
@namespace button
@brief button connection;
*/
InterruptIn button(PTB18);

Ticker ticker;
/**
@namespace buzzer
@brief buzzer connection;
*/
PwmOut buzzer(PTA2);
/**
@namespace  green_led
@brief led connection;
*/
PwmOut green_led(PTC2);

volatile bool yesno = false;/*!<create struct variable*/

/**
 Initializing on board LEDS 
*/
void green1();

/**
  Changing the variable 
*/
void green();

/**
 Initializing the k64F 
*/
void init_K64F();

