#include "main.h"

int main()
{
    init_K64F();//the k64f initialization
    button.fall(&green);//for interruptIn
    button.mode(PullNone);//for interruptIn
    lcd.init();//the lcd initialization
    wait(1.0);
    lcd.printString("Distance",18,1);//Display the Distance
    lcd.printString("Detector",18,3);//Display the Detector
    wait(1.0);
    lcd.clear();//clear the display
    lcd.printString("Kai yuan!",18,2);//Display the name Kai yuan
    lcd.printString("200967075",18,4);//Display the 200967075
    wait(2.0);
    lcd.clear();//clear the display
    button.mode(PullDown);//for interruptIn

    while(1) {
        if(yesno == true) {
            char buffer[14];// each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
            buzzer.period(0.001);  // try 1 kKz
            buzzer = 0.5;  // turn on (square wave)
            wait(1.0);
            lcd.clear();//clear the display
            int distance=sensor.getDistanceCm();//get distance
            int length = sprintf(buffer,"D = %d cm",distance);
            if (length <= 14)  {// if string will fit on display
                lcd.printString(buffer,0,1);
            }
            lcd.drawLine(0,24,0,48,1);//display the line
            lcd.drawRect(distance/5,31,10,5,1);//display the rectangle
            lcd.drawCircle(distance/5+3,37,1,1);//display the circle
            lcd.drawCircle(distance/5+7,37,1,1);//display the circle
            lcd.refresh();
            ticker.attach(&green1,0.1);//for led flashing

        }

        else {
            lcd.clear();
            lcd.printString("Are you ready?",0,2);
            buzzer = 0.0;  // turn off (0% duty cycle)
            ticker.detach();
            green_led = green_led;//turn off the led
        }
        r_led = 1;
        wait(0.5);
    }
}

void init_K64F()
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;

    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    button.mode(PullNone);
    button.mode(PullNone);

}

void green()
{
    yesno=!yesno;//true or false
}
void green1()
{
    green_led =! green_led;//make led light
}
